/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gfx.GfxTools;
import de.jave.jave.Jave;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.Plate;
import de.jave.jave.Tool;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class ArrowToolAlgorithmic
extends Tool {
    protected Point point1;
    protected Point point2;
    protected Choice chMode;
    protected static final int BIG = 0;
    protected static final int SMALL = 1;
    protected static final int AGGREGATION = 2;
    protected static final int CHARACTERS = 3;
    protected static final int N = 0;
    protected static final int NE = 1;
    protected static final int E = 2;
    protected static final int SE = 3;
    protected static final int S = 4;
    protected static final int SW = 5;
    protected static final int W = 6;
    protected static final int NW = 7;
    protected Checkbox cbMix;
    protected static final boolean DEFAULT_MIX = true;

    public ArrowToolAlgorithmic(Plate plate, Jave jave) {
        super(plate, jave);
    }

    public String getName() {
        return "Arrow Algorithmic";
    }

    public String getIconName() {
        return "arrow";
    }

    public boolean isMix() {
        if (this.cbMix == null) {
            return true;
        }
        return this.cbMix.getState();
    }

    public Component createOptionsComponent() {
        Panel panel = new Panel();
        Label label = new Label("THIS TOOL IS EXPERIMENTAL!");
        label.setFont(JaveGlobalRessources.FONT_ITALIC);
        panel.add(label);
        this.cbMix = new Checkbox("Mix", true);
        this.cbMix.addItemListener(this);
        panel.add(new Label("Style:", 2));
        this.chMode = new Choice();
        this.chMode.addItem("Big");
        this.chMode.addItem("Small");
        this.chMode.addItem("Aggregation");
        this.chMode.addItem("Character");
        this.chMode.select(0);
        this.chMode.addItemListener(this);
        panel.add(this.chMode);
        panel.add(this.cbMix);
        return panel;
    }

    public void takeToHand() {
        this.setCursor(JaveGlobalRessources.cursorSelection);
    }

    public void putAside(boolean bl) {
    }

    public void mousePressed(Point point, Point point2, MouseEvent mouseEvent) {
        if (point2 == null) {
            return;
        }
        this.point1 = point;
    }

    public void mouseDragged(Point point, Point point2, MouseEvent mouseEvent) {
        if (point2 == null) {
            if (this.point2 != null) {
                this.point2 = null;
                this.repaintCursor();
            }
            return;
        }
        if (point.equals(this.point2)) {
            return;
        }
        this.point2 = point;
        this.repaintCursor();
    }

    public void mouseReleased(Point point, Point point2, MouseEvent mouseEvent) {
        if (this.point1 == null || point == null || point2 == null) {
            return;
        }
        Point point3 = this.getLocationForScreenPoint(this.point1);
        if (point3 == null) {
            return;
        }
        Point point4 = this.getLocationForScreenPoint(point);
        if (point4 == null) {
            return;
        }
        int n = point3.x;
        int n2 = point3.y;
        int n3 = point4.x;
        int n4 = point4.y;
        int n5 = this.chMode.getSelectedIndex();
        this.setMixMode(this.cbMix.getState());
        int n6 = point.x - this.point1.x;
        int n7 = point.y - this.point1.y;
        int n8 = 0;
        int n9 = 0;
        if (n6 == 0) {
            if (n7 > 0) {
                n8 = 4;
                n9 = 4;
            } else {
                n8 = 0;
                n9 = 0;
            }
        } else {
            double d = Math.atan((double)n7 / (double)n6);
            if (n6 < 0) {
                d += Math.PI;
            }
            int n10 = (int)(((d += 1.5707963267948966) + 0.39269908169872414) % (Math.PI * 2) / 0.7853981633974483);
            int n11 = (int)((d + 0.7853981633974483) % (Math.PI * 2) / 1.5707963267948966);
            switch (n10) {
                case 0: {
                    n9 = 0;
                    break;
                }
                case 1: {
                    n9 = 1;
                    break;
                }
                case 2: {
                    n9 = 2;
                    break;
                }
                case 3: {
                    n9 = 3;
                    break;
                }
                case 4: {
                    n9 = 4;
                    break;
                }
                case 5: {
                    n9 = 5;
                    break;
                }
                case 6: {
                    n9 = 6;
                    break;
                }
                case 7: {
                    n9 = 7;
                }
            }
            switch (n11) {
                case 0: {
                    n8 = 0;
                    break;
                }
                case 1: {
                    n8 = 2;
                    break;
                }
                case 2: {
                    n8 = 4;
                    break;
                }
                case 3: {
                    n8 = 6;
                }
            }
        }
        this.drawArrow(point2, n8, n9);
        this.saveCurrentState("draw arrow");
        this.repaintAll();
        this.point1 = null;
        this.point2 = null;
    }

    public void paintCursorFeature(Graphics graphics) {
        if (this.point1 != null && this.point2 != null) {
            graphics.setColor(JaveGlobalRessources.colorTool);
            graphics.drawLine(this.point1.x, this.point1.y, this.point2.x, this.point2.y);
            GfxTools.paintArrow(graphics, this.point1, this.point2);
        }
    }

    protected void drawArrow(Point point, int n, int n2) {
        int n3 = this.chMode.getSelectedIndex();
        switch (n3) {
            case 1: {
                switch (n) {
                    case 0: {
                        this.plate.setCharForce(point, '^');
                        break;
                    }
                    case 2: {
                        this.plate.setCharForce(point, '>');
                        break;
                    }
                    case 4: {
                        this.plate.setCharForce(point, 'V');
                        break;
                    }
                    case 6: {
                        this.plate.setCharForce(point, '<');
                    }
                }
                break;
            }
            case 0: {
                switch (n2) {
                    case 0: {
                        this.plate.setCharForce(point, '^');
                        this.plate.setCharForce(point.x - 1, point.y + 1, '/');
                        this.plate.setCharForce(point.x + 1, point.y + 1, '\\');
                        this.plate.setCharForce(point.x, point.y + 1, '|');
                        break;
                    }
                    case 1: {
                        this.plate.setCharForce(point, '/');
                        this.plate.setCharForce(point.x + 1, point.y, '|');
                        this.plate.setCharForce(point.x + 1, point.y + 1, '|');
                        this.plate.setCharForce(point.x, point.y - 1, '_');
                        this.plate.setCharForce(point.x - 1, point.y - 1, '_');
                        this.plate.setCharForce(point.x - 2, point.y - 1, '_');
                        break;
                    }
                    case 2: {
                        this.plate.setCharForce(point, '>');
                        this.plate.setCharForce(point.x - 1, point.y + 1, '/');
                        this.plate.setCharForce(point.x - 1, point.y - 1, '\\');
                        this.plate.setCharForce(point.x - 1, point.y, '-');
                        break;
                    }
                    case 3: {
                        this.plate.setCharForce(point, '\\');
                        this.plate.setCharForce(point.x + 1, point.y, '|');
                        this.plate.setCharForce(point.x + 1, point.y - 1, '|');
                        this.plate.setCharForce(point.x - 1, point.y, '_');
                        this.plate.setCharForce(point.x - 2, point.y, '_');
                        break;
                    }
                    case 4: {
                        this.plate.setCharForce(point, 'V');
                        this.plate.setCharForce(point.x - 1, point.y - 1, '\\');
                        this.plate.setCharForce(point.x + 1, point.y - 1, '/');
                        this.plate.setCharForce(point.x, point.y - 1, '|');
                        break;
                    }
                    case 5: {
                        this.plate.setCharForce(point, '/');
                        this.plate.setCharForce(point.x - 1, point.y, '|');
                        this.plate.setCharForce(point.x - 1, point.y - 1, '|');
                        this.plate.setCharForce(point.x + 1, point.y, '_');
                        this.plate.setCharForce(point.x + 2, point.y, '_');
                        break;
                    }
                    case 6: {
                        this.plate.setCharForce(point, '<');
                        this.plate.setCharForce(point.x + 1, point.y + 1, '\\');
                        this.plate.setCharForce(point.x + 1, point.y - 1, '/');
                        this.plate.setCharForce(point.x + 1, point.y, '-');
                        break;
                    }
                    case 7: {
                        this.plate.setCharForce(point, '\\');
                        this.plate.setCharForce(point.x - 1, point.y, '|');
                        this.plate.setCharForce(point.x - 1, point.y + 1, '|');
                        this.plate.setCharForce(point.x, point.y - 1, '_');
                        this.plate.setCharForce(point.x + 1, point.y - 1, '_');
                        this.plate.setCharForce(point.x + 2, point.y - 1, '_');
                    }
                }
                break;
            }
            case 2: {
                switch (n) {
                    case 0: {
                        this.plate.setCharForce(point, '^');
                        this.plate.setCharForce(point.x - 1, point.y + 1, '/');
                        this.plate.setCharForce(point.x + 1, point.y + 1, '\\');
                        this.plate.setCharForce(point.x - 1, point.y + 2, '\\');
                        this.plate.setCharForce(point.x + 1, point.y + 2, '/');
                        this.plate.setCharForce(point.x, point.y + 1, ' ');
                        this.plate.setCharForce(point.x, point.y + 2, ' ');
                        this.plate.setCharForce(point.x, point.y + 3, 'V');
                        break;
                    }
                    case 2: {
                        this.plate.setCharForce(point, '>');
                        this.plate.setCharForce(point.x - 1, point.y + 1, '/');
                        this.plate.setCharForce(point.x - 1, point.y - 1, '\\');
                        this.plate.setCharForce(point.x - 2, point.y + 1, '\\');
                        this.plate.setCharForce(point.x - 2, point.y - 1, '/');
                        this.plate.setCharForce(point.x - 1, point.y, ' ');
                        this.plate.setCharForce(point.x - 2, point.y, ' ');
                        this.plate.setCharForce(point.x - 3, point.y, '<');
                        break;
                    }
                    case 4: {
                        this.plate.setCharForce(point, 'V');
                        this.plate.setCharForce(point.x + 1, point.y - 1, '/');
                        this.plate.setCharForce(point.x - 1, point.y - 1, '\\');
                        this.plate.setCharForce(point.x + 1, point.y - 2, '\\');
                        this.plate.setCharForce(point.x - 1, point.y - 2, '/');
                        this.plate.setCharForce(point.x, point.y - 1, ' ');
                        this.plate.setCharForce(point.x, point.y - 2, ' ');
                        this.plate.setCharForce(point.x, point.y - 3, '^');
                        break;
                    }
                    case 6: {
                        this.plate.setCharForce(point, '<');
                        this.plate.setCharForce(point.x + 1, point.y - 1, '/');
                        this.plate.setCharForce(point.x + 1, point.y + 1, '\\');
                        this.plate.setCharForce(point.x + 2, point.y - 1, '\\');
                        this.plate.setCharForce(point.x + 2, point.y + 1, '/');
                        this.plate.setCharForce(point.x + 1, point.y, ' ');
                        this.plate.setCharForce(point.x + 2, point.y, ' ');
                        this.plate.setCharForce(point.x + 3, point.y, '>');
                    }
                }
                break;
            }
            case 3: {
                this.plate.setCharForce(point, this.getMouseChar());
            }
        }
    }
}

