/*
 * Decompiled with CFR 0.152.
 */
package de.jave.internet;

import java.awt.Color;
import java.util.Hashtable;

public class HTMLTools {
    protected static Hashtable entityTableEncode;
    protected static Hashtable entityTableDecode;
    protected static final String[] ENTITIES;

    private HTMLTools() {
    }

    protected static void buildEntityTables() {
        entityTableDecode = new Hashtable(ENTITIES.length);
        entityTableEncode = new Hashtable(ENTITIES.length);
        int n = 0;
        while (n < ENTITIES.length) {
            if (!entityTableDecode.containsKey(ENTITIES[n])) {
                entityTableDecode.put(ENTITIES[n], ENTITIES[n + 1]);
            }
            if (!entityTableEncode.containsKey(ENTITIES[n + 1])) {
                entityTableEncode.put(ENTITIES[n + 1], ENTITIES[n]);
            }
            n += 2;
        }
    }

    public static String unHTML(String string) {
        return HTMLTools.decodeEntities(HTMLTools.removeTags(string));
    }

    public static String removeTags(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = -1;
        int n2 = string.indexOf("<");
        while (n2 != -1) {
            stringBuffer.append(string.substring(n + 1, n2));
            n = string.indexOf(">", n2);
            if (n == -1) {
                n = string.length() - 1;
                break;
            }
            n2 = string.indexOf("<", n);
        }
        stringBuffer.append(string.substring(n + 1, string.length()));
        return stringBuffer.toString();
    }

    public static String decodeEntities(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = -1;
        int n2 = string.indexOf("&");
        while (n2 != -1) {
            stringBuffer.append(string.substring(n + 1, n2));
            n = string.indexOf(";", n2);
            if (n == -1) {
                n = string.length() - 1;
                break;
            }
            stringBuffer.append(HTMLTools.decodeEntity(string.substring(n2, n + 1)));
            n2 = string.indexOf("&", n);
        }
        stringBuffer.append(string.substring(n + 1, string.length()));
        return stringBuffer.toString();
    }

    public static String decodeEntity(String string) {
        String string2;
        if (entityTableDecode == null) {
            HTMLTools.buildEntityTables();
        }
        if ((string2 = (String)entityTableDecode.get(string)) == null) {
            System.err.println("Unknown HTML-Entity '" + string + "' in HTMLTools.decodeEntity(). Ignored");
            return string;
        }
        return string2;
    }

    public static final String encode(String string) {
        if (entityTableEncode == null) {
            HTMLTools.buildEntityTables();
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c >= '?' && c <= 'Z' || c >= 'a' && c <= 'z') {
                stringBuffer.append(c);
            } else {
                stringBuffer.append(HTMLTools.encodeSingleChar(String.valueOf(c)));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    protected static final String encodeSingleChar(String string) {
        String string2 = (String)entityTableEncode.get(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public static final String toHTML(Color color) {
        String string = Integer.toHexString(color.getRed());
        String string2 = Integer.toHexString(color.getGreen());
        String string3 = Integer.toHexString(color.getBlue());
        if (string.length() == 1) {
            string = "0" + string;
        }
        if (string2.length() == 1) {
            string2 = "0" + string2;
        }
        if (string3.length() == 1) {
            string3 = "0" + string3;
        }
        return "#" + string + string2 + string3;
    }

    public static void main(String[] stringArray) {
        String string = "<dl>  <dt>&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"http://www.kimwilde.com/\"><b>Wilde</b>, <b>Kim</b> - KimWilde.com</a><br>  <dd><i>LookSmart</i>: Browse FAQs, a discography, a videography, <b>lyrics</b>,album reviews, and fan club information.<br><i>Google</i>: ...Netword enabled. Don't miss the <b>Kim</b> <b>Wilde</b> Birthday chat on...<br><font size=\"-3\">1000,&nbsp;http://www.kimwilde.com/ (<a target=\"_blank\" href=\"http://www.looksmart.com/r_search?look=&search=&key=lyrics+kim+wilde&isp=zl&comefrom=izl-sitematch\">LookSmart</a>, <a target=\"_blank\" href=\"http://www.google.com/search?q=lyrics+kim+wilde\">Google</a>)</font><p></dl>";
        System.out.println(HTMLTools.decodeEntities(HTMLTools.removeTags(string)));
    }

    static {
        ENTITIES = new String[]{" ", " ", "-", "-", "'", "'", "`", "`", "&Uuml;", "\u00dc", "&Auml;", "\u00c4", "&Ouml;", "\u00d6", "&Euml;", "\u00cb", "&Ccedil;", "\u00c7", "&AElig;", "\u00c6", "&Aring;", "\u00c5", "&Oslash;", "\u00d8", "&uuml;", "\u00fc", "&auml;", "\u00e4", "&ouml;", "\u00f6", "&euml;", "\u00eb", "&ccedil;", "\u00e7", "&aring;", "\u00e5", "&oslash;", "\u00f8", "&grave;", "`", "&agrave;", "\u00e0", "&egrave;", "\u00e8", "&igrave;", "\u00ec", "&ograve;", "\u00f2", "&ugrave;", "\u00f9", "&amp;", "&", "&#34;", "\"", "&szlig;", "\u00df", "&nbsp;", " ", "&gt;", ">", "&lt;", "<", "&copy;", "(C)", "&cent;", "\u00a2", "&pound;", "\u00a3", "&laquo;", "\u00ab", "&raquo;", "\u00bb", "&reg;", "(R)", "&middot;", " - ", "&times;", " x ", "&acute;", "'", "&aacute;", "\u00e1", "&uacute;", "\u00fa", "&oacute;", "\u00f3", "&eacute;", "\u00e9", "&iacute;", "\u00ed", "&ntilde;", "\u00f1", "&sect;", "\u00a7", "&egrave;", "\u00e8", "&icirc;", "\u00ee", "&ocirc;", "\u00f4", "&acirc;", "\u00e2", "&ucirc;", "\u00fb", "&ecirc;", "\u00ea", "&aelig;", "\u00e6", "&iexcl;", "\u00a1", "&#151;", "-", "&#0151;", "-", "&#0146;", "'", "&#146;", "'", "&#0145;", "'", "&#145;", "'", "&quot;", "\""};
    }
}

