/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii;

import de.jave.gfx.ImageLoader;
import de.jave.gui.GDialog;
import de.jave.image.GGreyscaleImage;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.PixelGrabber;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;

public class GreyscaleTableConverter
extends JComponent
implements ActionListener,
ItemListener,
MouseListener {
    protected Button bLoad;
    protected Button bCompute;
    protected Button bSave;
    protected JFrame frame;
    protected JComboBox cbDisplay = new JComboBox();
    protected static final Font FONT = new Font("Courier", 0, 11);
    protected Rectangle oo;
    protected Rectangle ou;
    protected Rectangle uo;
    protected Rectangle uu;
    protected Rectangle ll;
    protected Rectangle lr;
    protected Rectangle rl;
    protected Rectangle rr;
    protected String fileName;
    protected GGreyscaleImage image;
    protected Image rawImage;
    protected double boundsX0;
    protected double boundsY0;
    protected double boundsX1;
    protected double boundsY1;
    protected double charWidth = 0.0;
    protected double charHeight = 0.0;
    protected Rectangle[] fieldBounds;
    protected int[] greyscales;
    protected int[][] greyscales4;

    public GreyscaleTableConverter() {
        this.cbDisplay.addItem("normal");
        this.cbDisplay.addItem("1 pixel");
        this.cbDisplay.addItem("4 pixel");
        this.cbDisplay.addItemListener(this);
        this.bLoad = new Button("Load");
        this.bLoad.addActionListener(this);
        this.bCompute = new Button("Compute");
        this.bCompute.addActionListener(this);
        this.bCompute.setEnabled(false);
        this.bSave = new Button("Save");
        this.bSave.addActionListener(this);
        this.bSave.setEnabled(false);
        Panel panel = new Panel();
        panel.add(this.bLoad);
        panel.add(this.bCompute);
        panel.add(this.bSave);
        panel.add(this.cbDisplay);
        this.setBackground(Color.white);
        JScrollPane jScrollPane = new JScrollPane(this);
        jScrollPane.setPreferredSize(new Dimension(640, 400));
        this.frame = new JFrame();
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().add((Component)jScrollPane, "Center");
        this.frame.getContentPane().add((Component)panel, "South");
        this.frame.pack();
        this.frame.show();
        this.addMouseListener(this);
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.image != null && this.ll != null && this.uu != null) {
            int n;
            int n2 = mouseEvent.getX();
            if (this.ll.contains(n2, n = mouseEvent.getY())) {
                this.boundsX0 -= 0.5;
                this.computeRegions();
            } else if (this.lr.contains(n2, n)) {
                this.boundsX0 += 0.5;
                this.computeRegions();
            } else if (this.rr.contains(n2, n)) {
                this.boundsX1 += 0.5;
                this.computeRegions();
            } else if (this.rl.contains(n2, n)) {
                this.boundsX1 -= 0.5;
                this.computeRegions();
            } else if (this.ou.contains(n2, n)) {
                this.boundsY0 += 0.5;
                this.computeRegions();
            } else if (this.oo.contains(n2, n)) {
                this.boundsY0 -= 0.5;
                this.computeRegions();
            } else if (this.uu.contains(n2, n)) {
                this.boundsY1 += 0.5;
                this.computeRegions();
            } else if (this.uo.contains(n2, n)) {
                this.boundsY1 -= 0.5;
                this.computeRegions();
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public Dimension getPreferredSize() {
        if (this.image != null) {
            return this.image.getSize();
        }
        return new Dimension(200, 100);
    }

    public void paint(Graphics graphics) {
        int n;
        int n2 = this.cbDisplay.getSelectedIndex();
        graphics.setFont(FONT);
        if (this.rawImage != null) {
            graphics.drawImage(this.rawImage, 0, 0, this);
        }
        if (this.fieldBounds != null) {
            if (n2 == 2 && this.greyscales4 != null) {
                n = 0;
                while (n < this.fieldBounds.length) {
                    if (this.fieldBounds[n] != null) {
                        graphics.setColor(new Color(this.greyscales4[n][0], this.greyscales4[n][0], this.greyscales4[n][0]));
                        graphics.fillRect(this.fieldBounds[n].x, this.fieldBounds[n].y, this.fieldBounds[n].width / 2, this.fieldBounds[n].height / 2);
                        graphics.setColor(new Color(this.greyscales4[n][1], this.greyscales4[n][1], this.greyscales4[n][1]));
                        graphics.fillRect(this.fieldBounds[n].x + this.fieldBounds[n].width / 2, this.fieldBounds[n].y, this.fieldBounds[n].width / 2, this.fieldBounds[n].height / 2);
                        graphics.setColor(new Color(this.greyscales4[n][2], this.greyscales4[n][2], this.greyscales4[n][2]));
                        graphics.fillRect(this.fieldBounds[n].x, this.fieldBounds[n].y + this.fieldBounds[n].height / 2, this.fieldBounds[n].width / 2, this.fieldBounds[n].height / 2);
                        graphics.setColor(new Color(this.greyscales4[n][3], this.greyscales4[n][3], this.greyscales4[n][3]));
                        graphics.fillRect(this.fieldBounds[n].x + this.fieldBounds[n].width / 2, this.fieldBounds[n].y + this.fieldBounds[n].height / 2, this.fieldBounds[n].width / 2, this.fieldBounds[n].height / 2);
                    }
                    ++n;
                }
            } else if (n2 == 1 && this.greyscales != null) {
                n = 0;
                while (n < this.fieldBounds.length) {
                    if (this.fieldBounds[n] != null) {
                        graphics.setColor(new Color(this.greyscales[n], this.greyscales[n], this.greyscales[n]));
                        graphics.fillRect(this.fieldBounds[n].x, this.fieldBounds[n].y, this.fieldBounds[n].width, this.fieldBounds[n].height);
                    }
                    ++n;
                }
            }
        }
        graphics.setColor(new Color(1.0f, 0.0f, 0.0f, 0.3f));
        GreyscaleTableConverter.paintRect(graphics, this.ll);
        GreyscaleTableConverter.paintRect(graphics, this.lr);
        GreyscaleTableConverter.paintRect(graphics, this.rl);
        GreyscaleTableConverter.paintRect(graphics, this.rr);
        GreyscaleTableConverter.paintRect(graphics, this.oo);
        GreyscaleTableConverter.paintRect(graphics, this.ou);
        GreyscaleTableConverter.paintRect(graphics, this.uo);
        GreyscaleTableConverter.paintRect(graphics, this.uu);
        graphics.setColor(Color.red);
        graphics.drawRect((int)Math.round(this.boundsX0), (int)Math.round(this.boundsY0), (int)Math.round(this.boundsX1 - this.boundsX0), (int)Math.round(this.boundsY1 - this.boundsY0));
        if (this.fieldBounds != null) {
            graphics.setColor(Color.blue);
            n = 0;
            while (n < this.fieldBounds.length) {
                if (this.fieldBounds[n] != null) {
                    graphics.drawRect(this.fieldBounds[n].x, this.fieldBounds[n].y, this.fieldBounds[n].width, this.fieldBounds[n].height);
                    graphics.drawString("" + (char)(n + 32), this.fieldBounds[n].x + 2, this.fieldBounds[n].y - 2);
                }
                ++n;
            }
        }
    }

    protected static final void paintRect(Graphics graphics, Rectangle rectangle) {
        if (rectangle == null) {
            return;
        }
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static void main(String[] stringArray) {
        GreyscaleTableConverter greyscaleTableConverter = new GreyscaleTableConverter();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.bLoad) {
            this.doLoad();
        } else if (actionEvent.getSource() == this.bCompute) {
            this.doCompute();
        } else if (actionEvent.getSource() == this.bSave) {
            this.doSave();
        }
    }

    protected void doLoad() {
        int n;
        int n2;
        int n3;
        FileDialog fileDialog = new FileDialog((Frame)this.frame, "Open image", 0);
        fileDialog.show();
        String string = fileDialog.getFile();
        String string2 = fileDialog.getDirectory();
        if (string == null) {
            return;
        }
        String string3 = string.toLowerCase();
        if (!(string3.endsWith(".gif") || string3.endsWith(".jpg") || string3.endsWith(".jpeg") || string3.endsWith(".bmp"))) {
            String string4 = "Wrong file format?\nSupported formats: GIF, JPG, BMP (experimental).";
            new GDialog((Frame)this.frame, "Image2Ascii", "Error loading image", string4, 3).show();
            return;
        }
        this.frame.setTitle(string);
        this.fileName = string2 + string;
        this.rawImage = ImageLoader.loadImage(this.fileName, this);
        int n4 = this.rawImage.getWidth(this);
        int n5 = this.rawImage.getHeight(this);
        int[] nArray = new int[n4 * n5];
        PixelGrabber pixelGrabber = new PixelGrabber(this.rawImage, 0, 0, n4, n5, nArray, 0, n4);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Internal Error: " + interruptedException.toString());
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            throw new RuntimeException("Internal Error: Image fetch aborted or errored.");
        }
        this.image = new GGreyscaleImage(nArray, n4, n5);
        this.rr = null;
        this.rl = null;
        this.lr = null;
        this.ll = null;
        this.oo = null;
        this.ou = null;
        this.uo = null;
        this.uu = null;
        this.fieldBounds = null;
        this.greyscales = null;
        this.greyscales4 = null;
        this.invalidate();
        this.frame.pack();
        this.repaint();
        System.out.println(n4 + "x" + n5);
        int n6 = 0;
        int n7 = 0;
        while (n7 < n4) {
            int n8 = 0;
            while (n8 < n5) {
                if (this.image.get(n7, n8) > n6) {
                    n6 = this.image.get(n7, n8);
                }
                ++n8;
            }
            ++n7;
        }
        int n9 = n6 * 3 / 4;
        int n10 = 0;
        while (true) {
            n3 = 0;
            n3 = 0;
            while (n3 < n4) {
                if (this.image.get(n3, n10) < n9) break;
                ++n3;
            }
            if (n3 != n4) break;
            ++n10;
        }
        n3 = 0;
        while (true) {
            n2 = 0;
            n2 = 0;
            while (n2 < n5) {
                if (this.image.get(n3, n2) < n9) break;
                ++n2;
            }
            if (n2 != n5) break;
            ++n3;
        }
        n2 = 0;
        while (true) {
            n = 0;
            n = 0;
            while (n < n4) {
                if (this.image.get(n, n5 - n2 - 1) < n9) break;
                ++n;
            }
            if (n != n4) break;
            ++n2;
        }
        n = 0;
        while (true) {
            int n11 = 0;
            n11 = 0;
            while (n11 < n5) {
                if (this.image.get(n4 - n - 1, n11) < n9) break;
                ++n11;
            }
            if (n11 != n5) break;
            ++n;
        }
        this.boundsX0 = n3;
        this.boundsY0 = n10;
        this.boundsX1 = n4 - n;
        this.boundsY1 = n5 - n2;
        this.computeRegions();
        this.bCompute.setEnabled(true);
        this.repaint();
    }

    protected void computeRegions() {
        this.charWidth = (this.boundsX1 - this.boundsX0) / 21.0 / 3.0;
        this.charHeight = (this.boundsY1 - this.boundsY0) / 7.0 / 3.0;
        double d = 6.0;
        double d2 = 40.0;
        this.ll = new Rectangle((int)Math.round(this.boundsX0 - d), (int)Math.round(this.boundsY0 + d2), (int)Math.round(d), (int)Math.round(this.boundsY1 - this.boundsY0 - d2 - d2));
        this.lr = new Rectangle((int)Math.round(this.boundsX0), (int)Math.round(this.boundsY0 + d2), (int)Math.round(d), (int)Math.round(this.boundsY1 - this.boundsY0 - d2 - d2));
        this.rr = new Rectangle((int)Math.round(this.boundsX1), (int)Math.round(this.boundsY0 + d2), (int)Math.round(d), (int)Math.round(this.boundsY1 - this.boundsY0 - d2 - d2));
        this.rl = new Rectangle((int)Math.round(this.boundsX1 - d), (int)Math.round(this.boundsY0 + d2), (int)Math.round(d), (int)Math.round(this.boundsY1 - this.boundsY0 - d2 - d2));
        this.oo = new Rectangle((int)Math.round(this.boundsX0 + d2), (int)Math.round(this.boundsY0 - d), (int)Math.round(this.boundsX1 - this.boundsX0 - d2 - d2), (int)Math.round(d));
        this.ou = new Rectangle((int)Math.round(this.boundsX0 + d2), (int)Math.round(this.boundsY0), (int)Math.round(this.boundsX1 - this.boundsX0 - d2 - d2), (int)Math.round(d));
        this.uo = new Rectangle((int)Math.round(this.boundsX0 + d2), (int)Math.round(this.boundsY1 - d), (int)Math.round(this.boundsX1 - this.boundsX0 - d2 - d2), (int)Math.round(d));
        this.uu = new Rectangle((int)Math.round(this.boundsX0 + d2), (int)Math.round(this.boundsY1), (int)Math.round(this.boundsX1 - this.boundsX0 - d2 - d2), (int)Math.round(d));
        this.fieldBounds = new Rectangle[96];
        int n = 32;
        while (n < 127) {
            int n2 = (n - 32) % 19;
            int n3 = (n - 32) / 19;
            double d3 = this.boundsX0 + ((double)n2 * 3.0 + 3.0) * this.charWidth;
            double d4 = d3 + 2.0 * this.charWidth;
            double d5 = this.boundsY0 + ((double)n3 * 3.0 + 3.0) * this.charHeight;
            double d6 = d5 + 2.0 * this.charHeight;
            this.fieldBounds[n - 32] = new Rectangle((int)Math.round(d3), (int)Math.round(d5), (int)Math.round(2.0 * this.charWidth), (int)Math.round(2.0 * this.charHeight));
            ++n;
        }
        this.repaint();
    }

    protected void doCompute() {
        int n;
        int n2;
        double[] dArray = new double[96];
        double[] dArray2 = new double[96];
        double[] dArray3 = new double[96];
        double[] dArray4 = new double[96];
        double[] dArray5 = new double[96];
        double d = 0.0;
        double d2 = -1.0;
        double d3 = 0.0;
        double d4 = -1.0;
        double d5 = 0.0;
        double d6 = -1.0;
        double d7 = 0.0;
        double d8 = -1.0;
        double d9 = 0.0;
        double d10 = -1.0;
        double d11 = 0.0;
        double d12 = -1.0;
        int n3 = 32;
        while (n3 < 127) {
            System.out.print((char)n3 + ": ");
            n2 = (n3 - 32) % 19;
            n = (n3 - 32) / 19;
            double d13 = this.boundsX0 + ((double)n2 * 3.0 + 3.0) * this.charWidth;
            double d14 = d13 + 2.0 * this.charWidth;
            double d15 = this.boundsY0 + ((double)n * 3.0 + 3.0) * this.charHeight;
            double d16 = d15 + 2.0 * this.charHeight;
            System.out.print(" " + d13 + ".." + d14 + " x " + d15 + ".." + d16 + " ");
            double d17 = GreyscaleTableConverter.sumUp(this.image, d13, d14, d15, d16);
            double d18 = this.charWidth / 2.0;
            double d19 = this.charHeight / 2.0;
            double d20 = this.charWidth;
            double d21 = this.charHeight;
            double d22 = GreyscaleTableConverter.sumUp(this.image, d13, d13 + d18, d15, d15 + d19) + GreyscaleTableConverter.sumUp(this.image, d13 + d20, d13 + d20 + d18, d15, d15 + d19) + GreyscaleTableConverter.sumUp(this.image, d13 + d20, d13 + d20 + d18, d15 + d21, d15 + d19 + d21) + GreyscaleTableConverter.sumUp(this.image, d13, d13 + d18, d15 + d21, d15 + d19 + d21);
            double d23 = GreyscaleTableConverter.sumUp(this.image, d13 + d18, d13 + d20, d15, d15 + d19) + GreyscaleTableConverter.sumUp(this.image, d13 + d20 + d18, d13 + d20 + d20, d15, d15 + d19) + GreyscaleTableConverter.sumUp(this.image, d13 + d20 + d18, d13 + d20 + d20, d15 + d21, d15 + d21 + d19) + GreyscaleTableConverter.sumUp(this.image, d13 + d18, d13 + d20, d15 + d21, d15 + d21 + d19);
            double d24 = GreyscaleTableConverter.sumUp(this.image, d13, d13 + d18, d15 + d19, d15 + d21) + GreyscaleTableConverter.sumUp(this.image, d13 + d20, d13 + d20 + d18, d15 + d19, d15 + d21) + GreyscaleTableConverter.sumUp(this.image, d13 + d20, d13 + d20 + d18, d15 + d19 + d21, d15 + d21 + d21) + GreyscaleTableConverter.sumUp(this.image, d13, d13 + d18, d15 + d19 + d21, d15 + d21 + d21);
            double d25 = GreyscaleTableConverter.sumUp(this.image, d13 + d18, d13 + d20, d15 + d19, d15 + d21) + GreyscaleTableConverter.sumUp(this.image, d13 + d18 + d20, d13 + d20 + d20, d15 + d19, d15 + d21) + GreyscaleTableConverter.sumUp(this.image, d13 + d18 + d20, d13 + d20 + d20, d15 + d19 + d21, d15 + d21 + d21) + GreyscaleTableConverter.sumUp(this.image, d13 + d18, d13 + d20, d15 + d19 + d21, d15 + d21 + d21);
            dArray[n3 - 32] = d17;
            dArray2[n3 - 32] = d22;
            dArray3[n3 - 32] = d23;
            dArray4[n3 - 32] = d24;
            dArray5[n3 - 32] = d25;
            if (d17 > d) {
                d = d17;
            }
            if (d2 < 0.0 || d17 < d2) {
                d2 = d17;
            }
            if (d22 > d11) {
                d11 = d22;
            }
            if (d23 > d11) {
                d11 = d23;
            }
            if (d24 > d11) {
                d11 = d24;
            }
            if (d25 > d11) {
                d11 = d25;
            }
            if (d12 < 0.0 || d22 < d12) {
                d12 = d22;
            }
            if (d23 < d12) {
                d12 = d23;
            }
            if (d24 < d12) {
                d12 = d24;
            }
            if (d25 < d12) {
                d12 = d25;
            }
            if (d22 > d3) {
                d3 = d22;
            }
            if (d4 < 0.0 || d22 < d4) {
                d4 = d22;
            }
            if (d23 > d5) {
                d5 = d23;
            }
            if (d6 < 0.0 || d23 < d6) {
                d6 = d23;
            }
            if (d24 > d7) {
                d7 = d24;
            }
            if (d8 < 0.0 || d24 < d8) {
                d8 = d24;
            }
            if (d25 > d9) {
                d9 = d25;
            }
            if (d10 < 0.0 || d25 < d10) {
                d10 = d25;
            }
            ++n3;
        }
        this.greyscales4 = new int[96][4];
        this.greyscales = new int[96];
        n2 = 32;
        while (n2 < 127) {
            this.greyscales[n2 - 32] = (int)Math.round((dArray[n2 - 32] - d2) / (d - d2) * 255.0);
            this.greyscales4[n2 - 32][0] = (int)Math.round((dArray2[n2 - 32] - d12) / (d11 - d12) * 255.0);
            this.greyscales4[n2 - 32][1] = (int)Math.round((dArray3[n2 - 32] - d12) / (d11 - d12) * 255.0);
            this.greyscales4[n2 - 32][2] = (int)Math.round((dArray4[n2 - 32] - d12) / (d11 - d12) * 255.0);
            this.greyscales4[n2 - 32][3] = (int)Math.round((dArray5[n2 - 32] - d12) / (d11 - d12) * 255.0);
            ++n2;
        }
        System.out.println(d2 + ".." + d);
        n = 32;
        while (n < 127) {
            System.out.println((char)n + " " + this.greyscales[n - 32]);
            ++n;
        }
        this.bSave.setEnabled(true);
    }

    protected void doSave() {
        String string = this.fileName.substring(0, this.fileName.length() - 4) + ".txt";
        try {
            File file = new File(string);
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            int n = 32;
            while (n < 127) {
                bufferedWriter.write((char)n + " " + this.greyscales[n - 32] + " " + this.greyscales4[n - 32][0] + " " + this.greyscales4[n - 32][1] + " " + this.greyscales4[n - 32][2] + " " + this.greyscales4[n - 32][3]);
                bufferedWriter.newLine();
                ++n;
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace();
            return;
        }
        System.out.println("Result saved to file " + string);
    }

    protected static final double sumUp(GGreyscaleImage gGreyscaleImage, double d, double d2, double d3, double d4) {
        double d5 = 0.0;
        int n = 0;
        double d6 = d;
        while (d6 < d2) {
            double d7 = d3;
            while (d7 < d4) {
                d5 += (double)gGreyscaleImage.getValueAt(d6, d7);
                ++n;
                d7 += 0.1;
            }
            d6 += 0.5;
        }
        return d5 /= (double)n;
    }
}

