/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui;

import de.jave.gui.GLabel;
import de.jave.gui.GLine;
import de.jave.gui.Gap;
import de.jave.gui.WizardSideLabel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public abstract class Wizard
extends Dialog
implements WindowListener {
    protected Button bCancel;
    protected Button bPrev;
    protected Button bNext;
    protected Button bHelp;
    protected int step;
    protected GLabel label;
    protected GLabel lInstructions;
    protected Panel panel;
    protected CardLayout cardLayout;
    protected WizardSideLabel sideLabel;
    protected static final String BACK = "<< Back";
    protected static final String NEXT = "Next >>";
    protected static final String FINISH = "Finish";
    protected static final String HELP = "Help";
    protected static final String CANCEL = "Cancel";
    protected static final Color COLOR_SIDELABEL = new Color(224, 224, 224);

    public Wizard(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        this.addWindowListener(this);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object == Wizard.this.bCancel) {
                    Wizard.this.cancel();
                } else if (object == Wizard.this.bHelp) {
                    Wizard.this.help();
                } else if (object == Wizard.this.bPrev) {
                    if (Wizard.this.step > 0) {
                        Wizard.this.setStep(Wizard.this.step - 1);
                        Wizard.this.stepChanged();
                    }
                } else if (object == Wizard.this.bNext) {
                    if (Wizard.this.step == Wizard.this.getStepCount() - 1) {
                        Wizard.this.finish();
                    } else {
                        Wizard.this.setStep(Wizard.this.step + 1);
                        Wizard.this.stepChanged();
                    }
                }
            }
        };
        this.bPrev = new Button(BACK);
        this.bPrev.addActionListener(actionListener);
        this.bNext = new Button(NEXT);
        this.bNext.addActionListener(actionListener);
        this.bCancel = new Button(CANCEL);
        this.bCancel.addActionListener(actionListener);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(2, 0, 5));
        panel.add(this.bPrev);
        panel.add(this.bNext);
        panel.add(new Gap(10, 10));
        panel.add(this.bCancel);
        if (this.hasHelp()) {
            this.bHelp = new Button(HELP);
            this.bHelp.addActionListener(actionListener);
            panel.add(new Gap(10, 10));
            panel.add(this.bHelp);
        } else {
            panel.add(new Gap(5, 5));
        }
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout());
        panel2.add((Component)panel, "Center");
        panel2.add((Component)new GLine(0), "North");
        this.label = new GLabel(this.getLabelForStep(0), 0);
        this.label.setFont(new Font("Dialog", 1, 14));
        this.label.setBackground(Color.white, Color.gray);
        this.lInstructions = new GLabel(this.getInstructionsForStep(0));
        this.lInstructions.setFont(new Font("Dialog", 0, 11));
        Panel panel3 = new Panel();
        panel3.setLayout(new BorderLayout(2, 2));
        panel3.add((Component)this.label, "North");
        panel3.add((Component)this.lInstructions, "Center");
        this.panel = new Panel();
        this.cardLayout = new CardLayout();
        this.panel.setLayout(this.cardLayout);
        this.setLayout(new BorderLayout(2, 2));
        Panel panel4 = new Panel();
        panel4.setLayout(new BorderLayout());
        panel4.add((Component)panel3, "North");
        panel4.add((Component)this.panel, "Center");
        this.add((Component)panel4, "Center");
        this.add((Component)panel2, "South");
        String[] stringArray = this.getSideLabels();
        if (stringArray != null) {
            this.sideLabel = new WizardSideLabel(stringArray);
            this.sideLabel.setBackground(COLOR_SIDELABEL);
            this.add((Component)this.sideLabel, "West");
        }
        int n = 0;
        while (n < this.getStepCount()) {
            Component component = this.createComponentForStep(n);
            if (component == null) {
                component = new Gap();
            }
            this.panel.add(component, String.valueOf(n));
            ++n;
        }
        this.setStep(0);
        this.pack();
    }

    public void help() {
    }

    public boolean hasHelp() {
        return false;
    }

    protected void setStep(int n) {
        this.step = n;
        this.label.setText(this.getLabelForStep(n));
        this.lInstructions.setText(this.getInstructionsForStep(n));
        this.cardLayout.show(this.panel, String.valueOf(n));
        if (this.sideLabel != null) {
            this.sideLabel.setStep(n);
        }
        this.bPrev.setEnabled(n != 0);
        if (n == this.getStepCount() - 1) {
            this.bNext.setLabel(FINISH);
        } else {
            this.bNext.setLabel(NEXT);
        }
    }

    public String[] getSideLabels() {
        return null;
    }

    public abstract void stepChanged();

    public abstract void cancel();

    public abstract void finish();

    public abstract int getStepCount();

    public abstract Component createComponentForStep(int var1);

    public abstract String getLabelForStep(int var1);

    public abstract String getInstructionsForStep(int var1);

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.cancel();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

