/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui;

import de.jave.gui.GuiTools;
import de.jave.gui.StatusDisplay;
import de.jave.gui.TooltipExtendedProducer;
import de.jave.gui.TooltipProducer;
import de.jave.gui.TooltipWindow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.TextComponent;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Hashtable;

public class Tooltips
extends Thread
implements MouseListener,
MouseMotionListener {
    public boolean shallStop;
    protected long popupTime = 150L;
    protected long popupTimeExtended = 1000L;
    protected long popupTimeDispose = 10000L;
    protected static final long DEFAULT_POPUP_TIME = 150L;
    protected static final long DEFAULT_POPUP_TIME_EXTENDED = 1000L;
    protected static final long DEFAULT_POPUP_TIME_DISPOSE = 10000L;
    protected static final int mouseMoveTolerance = 12;
    protected Hashtable table = new Hashtable();
    protected Hashtable tableExtended = new Hashtable();
    protected TooltipWindow popup;
    protected TooltipWindow popupExtended;
    protected Component popupComp;
    protected Object popupObject;
    protected Point prevPoint;
    protected boolean poppedUp = false;
    protected Point popupLocation;
    protected int state = 0;
    static final int DISABLED = 0;
    static final int WAITING = 1;
    static final int WAITING_EXTENDED = 2;
    static final int WAITING_DISPOSE = 3;
    protected StatusDisplay statusDisplay;
    protected TextComponent textDisplay;

    public Tooltips() {
        this.start();
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        this.shallStop = false;
        ** GOTO lbl49
        {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException var1_1) {
                // empty catch block
            }
            do {
                if (!this.shallStop && this.state == 0) continue block8;
                if (this.shallStop || this.state != 1) continue;
                var1_2 = System.currentTimeMillis();
                var3_3 = false;
                while (this.state == 1 && !var3_3) {
                    try {
                        Thread.sleep(this.popupTime);
                    }
                    catch (InterruptedException var4_5) {
                        // empty catch block
                    }
                    v0 = var3_3 = System.currentTimeMillis() - var1_2 >= this.popupTime;
                }
                if (var3_3 && this.state == 1) {
                    this.triggerPopup();
                    this.state = 2;
                    var1_2 = System.currentTimeMillis();
                    var3_3 = false;
                    while (this.state == 2 && !var3_3) {
                        try {
                            Thread.sleep(this.popupTimeExtended);
                        }
                        catch (InterruptedException var4_6) {
                            // empty catch block
                        }
                        v1 = var3_3 = System.currentTimeMillis() - var1_2 >= this.popupTimeExtended;
                    }
                    if (var3_3 && this.state == 2) {
                        this.triggerPopupExtended();
                    }
                    this.state = 3;
                    var1_2 = System.currentTimeMillis();
                    var3_3 = false;
                    while (this.state == 3 && !var3_3) {
                        try {
                            Thread.sleep(this.popupTimeDispose);
                        }
                        catch (InterruptedException var4_7) {
                            // empty catch block
                        }
                        v2 = var3_3 = System.currentTimeMillis() - var1_2 >= this.popupTimeDispose;
                    }
                    this.popDown();
                }
                this.state = 0;
lbl49:
                // 3 sources

            } while (!this.shallStop);
        }
    }

    public void setPopupTime(int n) {
        this.popupTime = n;
        this.interrupt();
    }

    public void setPopupTimeExtended(int n) {
        this.popupTimeExtended = n;
        this.interrupt();
    }

    public void add(Component component, String string) {
        if (component == null || string == null) {
            throw new IllegalArgumentException("Illegal arguments for adding a tooltip: " + component + ", " + string);
        }
        this.addInternal(component, string);
    }

    public void add(Component component, Component component2) {
        if (component == null || component2 == null) {
            throw new IllegalArgumentException("Illegal arguments for adding a tooltip: " + component + ", " + component2);
        }
        this.addInternal(component, component2);
    }

    public void add(Component component, TooltipProducer tooltipProducer) {
        if (component == null || tooltipProducer == null) {
            throw new IllegalArgumentException("Illegal arguments for adding a tooltip: " + component + ", " + tooltipProducer);
        }
        this.addInternal(component, tooltipProducer);
    }

    protected void addInternal(Component component, Object object) {
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
        this.table.put(component, object);
    }

    public void addExtended(Component component, String string) {
        if (component == null || string == null) {
            throw new IllegalArgumentException("Illegal arguments for adding an extended tooltip: " + component + ", " + string);
        }
        if (!this.table.containsKey(component)) {
            throw new IllegalArgumentException("Illegal to add an expanded tooltip without previously adding an ordinary tooltip: " + component + ", " + string);
        }
        this.tableExtended.put(component, string);
    }

    public void addExtended(Component component, Component component2) {
        if (component == null || component2 == null) {
            throw new IllegalArgumentException("Illegal arguments for adding an extended tooltip: " + component + ", " + component2);
        }
        if (!this.table.containsKey(component)) {
            throw new IllegalArgumentException("Illegal to add an expanded tooltip without previously adding an ordinary tooltip: " + component + ", " + component2);
        }
        this.tableExtended.put(component, component2);
    }

    public void addExtended(Component component, TooltipExtendedProducer tooltipExtendedProducer) {
        if (component == null || tooltipExtendedProducer == null) {
            throw new IllegalArgumentException("Illegal arguments for adding an extended tooltip: " + component + ", " + tooltipExtendedProducer);
        }
        if (!this.table.containsKey(component)) {
            throw new IllegalArgumentException("Illegal to add an expanded tooltip without previously adding an ordinary tooltip: " + component + ", " + tooltipExtendedProducer);
        }
        this.tableExtended.put(component, tooltipExtendedProducer);
    }

    public void removeAll() {
        Component component;
        Enumeration enumeration = this.table.keys();
        while (enumeration.hasMoreElements()) {
            component = (Component)enumeration.nextElement();
            component.removeMouseListener(this);
            component.removeMouseMotionListener(this);
        }
        this.table.clear();
        enumeration = this.tableExtended.keys();
        while (enumeration.hasMoreElements()) {
            component = (Component)enumeration.nextElement();
            component.removeMouseListener(this);
            component.removeMouseMotionListener(this);
        }
        this.tableExtended.clear();
    }

    public void remove(Component component) {
        this.stopThread();
        Object v = this.table.remove(component);
        if (v == null) {
            return;
        }
        component.removeMouseListener(this);
        component.removeMouseMotionListener(this);
        this.tableExtended.remove(component);
    }

    protected synchronized void popDown() {
        this.state = 0;
        this.interrupt();
        this.poppedUp = false;
        if (this.popup == null) {
            return;
        }
        this.popup.setVisible(false);
        if (this.popupExtended == null) {
            return;
        }
        this.popupExtended.setVisible(false);
    }

    protected synchronized void triggerPopup() {
        Frame frame = GuiTools.getParentFrame(this.popupComp);
        if (frame == null) {
            return;
        }
        if (this.popup != null) {
            this.popup.setVisible(false);
            if (GuiTools.getParentFrame(this.popup) == frame) {
                this.popup.removeAll();
            } else {
                this.popup = new TooltipWindow(frame);
            }
        } else {
            this.popup = new TooltipWindow(frame);
        }
        Object object = this.table.get(this.popupObject);
        if (object == null) {
            return;
        }
        if (object instanceof TooltipProducer) {
            object = ((TooltipProducer)object).produceTooltip(this.popupObject);
        }
        this.popup.setTip(object);
        this.popup.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.popup.getSize();
        Point point = this.popupLocation;
        point.y = point.y + 18 + dimension2.height >= dimension.height ? (point.y -= dimension2.height + 1) : (point.y += 18);
        if (point.x + dimension2.width >= dimension.width) {
            point.x = dimension.width - 1 - dimension2.width;
        }
        this.popup.setLocation(point);
        this.popup.show();
        this.poppedUp = true;
    }

    protected synchronized void triggerPopupExtended() {
        Object object = this.tableExtended.get(this.popupObject);
        if (object == null) {
            return;
        }
        if (object instanceof TooltipExtendedProducer) {
            object = ((TooltipExtendedProducer)object).produceExtendedTooltip(this.popupObject);
        }
        Component component = this.popupComp;
        while (component != null && !(component instanceof Frame)) {
            component = component.getParent();
        }
        if (component == null) {
            return;
        }
        this.popupExtended = new TooltipWindow((Frame)component);
        this.popupExtended.setTip(object);
        this.popupExtended.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.popupExtended.getSize();
        Dimension dimension3 = this.popup.getSize();
        Point point = this.popupLocation;
        Point point2 = this.popup.getLocationOnScreen();
        point.y = point2.y > this.popupLocation.y ? (point2.y + dimension3.height + dimension2.height < dimension.height ? point2.y + dimension3.height - 4 : this.popupLocation.y - dimension2.height - 3) : (this.popupLocation.y + dimension2.height + 18 < dimension.height ? (point.y += 18) : point2.y - dimension2.height);
        point.x += 10;
        if (point.x + dimension2.width >= dimension.width) {
            point.x = dimension.width - 10 - dimension2.width;
        }
        this.popupExtended.setLocation(point);
        this.popupExtended.show();
    }

    protected boolean isWithinTolerance(Point point, Point point2) {
        int n = point.x - point2.x;
        int n2 = n = n < 0 ? -n : n;
        if (n > 12) {
            return false;
        }
        n = point.y - point2.y;
        int n3 = n = n < 0 ? -n : n;
        return n <= 12;
    }

    protected synchronized void stopThread() {
        this.state = 0;
        this.interrupt();
    }

    protected void startThread() {
        this.state = 1;
        this.interrupt();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        if (this.poppedUp && component == this.popupComp) {
            if (this.isWithinTolerance(mouseEvent.getPoint(), this.prevPoint)) {
                return;
            }
            this.popDown();
            return;
        }
        this.stopThread();
        if (!this.table.containsKey(component)) {
            return;
        }
        Point point = component.getLocationOnScreen();
        this.popupLocation = new Point(point.x + mouseEvent.getX(), point.y + mouseEvent.getY());
        this.prevPoint = mouseEvent.getPoint();
        this.popupComp = component;
        this.popupObject = component;
        this.startThread();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.popDown();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.popDown();
        if (this.statusDisplay != null) {
            this.statusDisplay.showStatus("");
        }
        if (this.textDisplay != null) {
            this.textDisplay.setText("");
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.popDown();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.popDown();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.popDown();
        String string = (String)this.table.get(mouseEvent.getComponent());
        if (string == null) {
            return;
        }
        if (this.statusDisplay != null) {
            this.statusDisplay.showStatus(string);
        }
        if (this.textDisplay != null) {
            this.textDisplay.setText(string);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.popDown();
        if (this.statusDisplay != null) {
            this.statusDisplay.showStatus("");
        }
        if (this.textDisplay != null) {
            this.textDisplay.setText("");
        }
    }

    public void setStatusDisplay(StatusDisplay statusDisplay) {
        this.statusDisplay = statusDisplay;
    }

    public void setStatusDisplay(TextComponent textComponent) {
        this.textDisplay = textComponent;
    }
}

