/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui;

import de.jave.gfx.GfxTools;
import de.jave.gui.GImageLibrary;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.image.ImageObserver;
import java.util.Vector;

public class GTreeEntry
implements ImageObserver {
    protected Image image;
    protected Image imageOpen;
    public static final int ICON_NONE = -1;
    public static final int ICON_FOLDER = 0;
    public static final int ICON_DOCUMENT = 1;
    public static final int ICON_DRIVE = 2;
    protected boolean treeExpanded = true;
    protected boolean visibleInTree = true;
    protected int treeDepth;
    protected Vector children;
    protected String label;
    protected Object userobject;
    protected boolean selected;
    protected GTreeEntry parent;
    protected Rectangle bounds;
    protected Rectangle labelBounds;

    public GTreeEntry() {
        this("", 0);
    }

    public GTreeEntry(String string) {
        this(string, 0);
    }

    public GTreeEntry(int n) {
        this("", null, n);
    }

    public GTreeEntry(String string, int n) {
        this(string, null, n);
    }

    public GTreeEntry(String string, Object object, int n) {
        this.userobject = object;
        this.label = string;
        this.treeDepth = 0;
        this.children = new Vector(10);
        this.selected = false;
        if (n == 0) {
            this.image = GImageLibrary.getImage("folder_small");
            this.imageOpen = GImageLibrary.getImage("folder_small_open");
        } else if (n == 2) {
            this.image = GImageLibrary.getImage("harddisk");
            this.imageOpen = null;
        } else if (n == 1) {
            this.image = GImageLibrary.getImage("document");
            this.imageOpen = null;
        }
    }

    Rectangle getBounds() {
        return this.bounds;
    }

    Rectangle getLabelBounds() {
        return this.labelBounds;
    }

    public String toString() {
        return this.label;
    }

    public void select(boolean bl) {
        this.selected = bl;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public int countChildren() {
        int n = 1;
        int n2 = 0;
        while (n2 < this.children.size()) {
            n += ((GTreeEntry)this.children.elementAt(n2)).countChildren();
            ++n2;
        }
        return n;
    }

    public void add(GTreeEntry gTreeEntry) {
        gTreeEntry.parent = this;
        gTreeEntry.setTreeDepth(this.treeDepth + 1);
        this.children.addElement(gTreeEntry);
        gTreeEntry.setTreeExpanded(false);
        if (this.treeExpanded && this.visibleInTree) {
            gTreeEntry.setVisible(true);
        } else {
            gTreeEntry.setVisible(false);
        }
    }

    public void remove(GTreeEntry gTreeEntry) {
        this.children.removeElement(gTreeEntry);
    }

    public void removeAll() {
        while (this.children.size() > 0) {
            this.children.removeElementAt(this.children.size() - 1);
        }
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void setImageOpen(Image image) {
        this.imageOpen = image;
    }

    public void debug(String string) {
        System.err.println(string + "GTreeEntry '" + this.label + "' (" + this.treeDepth + ") exp=" + this.isTreeExpanded() + " sel=" + this.isSelected() + " vis=" + this.visibleInTree);
        int n = 0;
        while (n < this.children.size()) {
            ((GTreeEntry)this.children.elementAt(n)).debug(string + "  ");
            ++n;
        }
    }

    public GTreeEntry getParent() {
        return this.parent;
    }

    public Vector getChildren() {
        return this.children;
    }

    public boolean isTreeExpanded() {
        return this.treeExpanded;
    }

    public void expandAll(boolean bl) {
        this.treeExpanded = bl;
        if (this.treeDepth > 1) {
            this.visibleInTree = bl;
        }
        int n = 0;
        while (n < this.children.size()) {
            ((GTreeEntry)this.children.elementAt(n)).expandAll(bl);
            ++n;
        }
    }

    protected void setTreeDepth(int n) {
        this.treeDepth = n;
        int n2 = 0;
        while (n2 < this.children.size()) {
            ((GTreeEntry)this.children.elementAt(n2)).setTreeDepth(n + 1);
            ++n2;
        }
    }

    protected void toggleTreeExpansion() {
        this.setTreeExpanded(!this.isTreeExpanded());
    }

    protected void setTreeExpanded(boolean bl) {
        this.treeExpanded = bl;
        if (this.visibleInTree) {
            if (!bl) {
                int n = 0;
                while (n < this.children.size()) {
                    ((GTreeEntry)this.children.elementAt(n)).setVisible(false);
                    ++n;
                }
                return;
            }
            int n = 0;
            while (n < this.children.size()) {
                ((GTreeEntry)this.children.elementAt(n)).setVisible(true);
                ++n;
            }
            return;
        }
    }

    public boolean isVisibleInTree() {
        return this.visibleInTree;
    }

    protected void setVisible(boolean bl) {
        this.visibleInTree = bl;
        if (!bl) {
            int n = 0;
            while (n < this.children.size()) {
                ((GTreeEntry)this.children.elementAt(n)).setVisible(false);
                ++n;
            }
            return;
        }
        if (this.treeExpanded) {
            int n = 0;
            while (n < this.children.size()) {
                ((GTreeEntry)this.children.elementAt(n)).setVisible(true);
                ++n;
            }
        }
    }

    protected void getVisibleTreeEntries(Vector vector) {
        if (this.isVisibleInTree()) {
            vector.addElement(this);
            int n = 0;
            while (n < this.children.size()) {
                ((GTreeEntry)this.children.elementAt(n)).getVisibleTreeEntries(vector);
                ++n;
            }
        }
    }

    public int getTreeDepth() {
        return this.treeDepth;
    }

    public boolean isTreeLeave() {
        return this.children.size() == 0;
    }

    public String getTreeLabel() {
        return this.toString();
    }

    protected void setTreeLabel(String string) {
        this.label = string;
    }

    public void setUserObject(Object object) {
        this.userobject = object;
    }

    public Object getUserObject() {
        return this.userobject;
    }

    public boolean contains(Point point) {
        return this.bounds.contains(point);
    }

    public boolean hasIcon() {
        return this.image != null;
    }

    public boolean paint(Graphics graphics, FontMetrics fontMetrics, int n, int n2, int n3, int n4, boolean bl) {
        boolean bl2 = true;
        int n5 = n;
        if (this.hasIcon()) {
            bl2 = this.paintIcon(graphics, n, n2, n4, n4);
            n5 = n + n4 + 2;
        }
        int n6 = 0;
        if (this.label == null || this.label.equals("")) {
            this.bounds = new Rectangle(n, n2, n5 + 5 - n, n4);
            this.labelBounds = new Rectangle(n5, n2, 5, n4);
        } else {
            n6 = fontMetrics.stringWidth(this.label) + 4;
            this.labelBounds = new Rectangle(n5, n2, n6, n4);
        }
        if (this.isSelected()) {
            graphics.setColor(SystemColor.textHighlight);
            graphics.fillRect(this.labelBounds.x, this.labelBounds.y, this.labelBounds.width + 1, this.labelBounds.height + 1);
            if (bl) {
                GfxTools.drawDottedRectangle(graphics, new Color(255 - SystemColor.textHighlight.getRed(), 255 - SystemColor.textHighlight.getGreen(), 255 - SystemColor.textHighlight.getBlue()), Color.black, this.labelBounds.x, this.labelBounds.y, this.labelBounds.width, this.labelBounds.height);
            }
            graphics.setColor(SystemColor.textHighlightText);
        } else {
            graphics.setColor(Color.black);
        }
        if (this.label != null && !this.label.equals("")) {
            graphics.drawString(this.label, n5 + 3, n2 + n4 - 3);
            this.bounds = new Rectangle(n, n2, n5 + n6 - n, n4);
        }
        return bl2;
    }

    public boolean paintIcon(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n + n3 / 2;
        int n6 = n2 + n4 / 2;
        if (this.isTreeExpanded() && this.imageOpen != null) {
            return graphics.drawImage(this.imageOpen, n5 - this.imageOpen.getWidth(this) / 2 + 1, n6 - this.imageOpen.getHeight(this) / 2 + 1, this);
        }
        if (this.image != null) {
            return graphics.drawImage(this.image, n5 - this.image.getWidth(this) / 2 + 1, n6 - this.image.getHeight(this) / 2 + 1, this);
        }
        return true;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return (n & 0x20) != 32;
    }
}

