/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui;

import de.jave.gfx.GfxTools;
import de.jave.gui.GTree;
import de.jave.gui.GTreeEntry;
import de.jave.gui.TextEditWindow;
import de.jave.gui.TextEditWindowResultListener;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

class GTreeCanvas
extends Canvas
implements MouseListener,
FocusListener,
KeyListener,
TextEditWindowResultListener {
    protected GTree tree;
    protected boolean visibleEntriesModified;
    protected boolean selectionOrLabelChanged;
    protected Vector visibleEntries;
    protected GTreeEntry root;
    private static final Font font = new Font("Dialog", 0, 11);
    protected static final int CELL_WIDTH = 16;
    protected static final int CELL_HEIGHT = 16;
    private static final Color COLOR_LINES = Color.gray;
    private Dimension offDimension;
    private Image offImage;
    private Graphics offGraphics;
    protected FontMetrics fontMetrics;
    protected boolean focus;
    protected Point lastPoint;

    public GTreeCanvas(GTree gTree, GTreeEntry gTreeEntry) {
        this.tree = gTree;
        this.root = gTreeEntry;
        gTreeEntry.setTreeExpanded(true);
        this.fontMetrics = this.getFontMetrics(font);
        this.addMouseListener(this);
        this.addFocusListener(this);
        this.addKeyListener(this);
        this.visibleEntriesModified = true;
        this.focus = false;
    }

    public static final void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public GTreeEntry getRoot() {
        return this.root;
    }

    public void setRoot(GTreeEntry gTreeEntry) {
        this.root = gTreeEntry;
        gTreeEntry.setTreeExpanded(true);
        this.visibleEntriesModified = true;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void focusGained(FocusEvent focusEvent) {
        this.focus = true;
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.focus = false;
        this.repaint();
    }

    public Dimension getPreferredSize() {
        if (this.root == null) {
            return new Dimension(10, 10);
        }
        Vector vector = this.getVisibleEntries();
        int n = 10;
        int n2 = 0;
        while (n2 < vector.size()) {
            GTreeEntry gTreeEntry = (GTreeEntry)vector.elementAt(n2);
            int n3 = gTreeEntry.getTreeDepth() * 16 + 16;
            String string = gTreeEntry.getTreeLabel();
            if (string != null) {
                n3 += this.fontMetrics.stringWidth(string);
            }
            if ((n3 += 8) > n) {
                n = n3;
            }
            ++n2;
        }
        int n4 = vector.size() * 16 + 1;
        return new Dimension(n, n4);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.offGraphics == null || dimension.width != this.offDimension.width || dimension.height != this.offDimension.height) {
            this.offDimension = dimension;
            this.offImage = this.createImage(dimension.width, dimension.height);
            this.offGraphics = this.offImage.getGraphics();
            this.update(graphics);
        } else {
            graphics.drawImage(this.offImage, 0, 0, this);
        }
    }

    public void update(Graphics graphics) {
        this.selectionOrLabelChanged = false;
        long l = System.currentTimeMillis();
        boolean bl = true;
        Dimension dimension = this.getSize();
        if (this.offGraphics == null || dimension.width != this.offDimension.width || dimension.height != this.offDimension.height) {
            this.offDimension = dimension;
            this.offImage = this.createImage(dimension.width, dimension.height);
            this.offGraphics = this.offImage.getGraphics();
        }
        this.offGraphics.setColor(this.getBackground());
        this.offGraphics.fillRect(0, 0, dimension.width, dimension.height);
        this.offGraphics.setFont(font);
        Vector vector = this.getVisibleEntries();
        GTreeEntry gTreeEntry = null;
        int n = 0;
        while (n < vector.size()) {
            int n2;
            GTreeEntry gTreeEntry2 = (GTreeEntry)vector.elementAt(n);
            gTreeEntry = n < vector.size() - 1 ? (GTreeEntry)vector.elementAt(n + 1) : null;
            int n3 = gTreeEntry2.getTreeDepth();
            this.offGraphics.setColor(COLOR_LINES);
            if (n3 > 0) {
                n2 = (n3 - 1) * 16 + 8 + 1;
                int n4 = n * 16;
                int n5 = (n + 1) * 16 - 8;
                if (gTreeEntry != null && gTreeEntry.getTreeDepth() >= n3) {
                    int n6 = n + 1;
                    while (n6 < vector.size() - 1 && ((GTreeEntry)vector.elementAt(n6)).getTreeDepth() > n3) {
                        ++n6;
                    }
                    if (((GTreeEntry)vector.elementAt(n6)).getTreeDepth() == n3) {
                        this.offGraphics.drawLine(n2, n4, n2, n6 * 16);
                    } else {
                        this.offGraphics.drawLine(n2, n4, n2, n5);
                    }
                } else if (gTreeEntry == null || gTreeEntry.getTreeDepth() < n3) {
                    this.offGraphics.drawLine(n2, n4, n2, n5);
                }
                this.offGraphics.drawLine(n2, n5, n2 + 8, n5);
                if (!gTreeEntry2.isTreeLeave()) {
                    GTreeCanvas.paintBox(this.offGraphics, n2, n * 16, gTreeEntry2.isTreeExpanded());
                }
            }
            if (!gTreeEntry2.paint(this.offGraphics, this.fontMetrics, n2 = n3 * 16, n * 16, -1, 16, this.focus)) {
                bl = false;
            }
            ++n;
        }
        graphics.drawImage(this.offImage, 0, 0, this);
        if (!bl) {
            this.repaint(100L);
        }
    }

    protected static void paintBox(Graphics graphics, int n, int n2, boolean bl) {
        graphics.setColor(SystemColor.control);
        graphics.fillRect(n - 4, (n2 += 9) - 5, 8, 8);
        graphics.setColor(SystemColor.controlShadow);
        graphics.drawLine(n + 4, n2 - 4, n + 4, n2 + 3);
        graphics.drawLine(n - 3, n2 + 3, n + 3, n2 + 3);
        graphics.setColor(SystemColor.controlLtHighlight);
        graphics.drawLine(n - 4, n2 - 5, n + 4, n2 - 5);
        graphics.drawLine(n - 4, n2 - 4, n - 4, n2 + 3);
        graphics.setColor(SystemColor.controlText);
        graphics.drawLine(n - 2, n2 - 1, n + 2, n2 - 1);
        if (!bl) {
            graphics.drawLine(n, n2 - 3, n, n2 + 1);
        }
    }

    public synchronized Vector getVisibleEntries() {
        if (!this.visibleEntriesModified) {
            return this.visibleEntries;
        }
        this.visibleEntries = new Vector();
        this.root.getVisibleTreeEntries(this.visibleEntries);
        this.visibleEntriesModified = false;
        return this.visibleEntries;
    }

    public void edit(GTreeEntry gTreeEntry) {
        System.err.println("Eintrag " + gTreeEntry + " wird editiert");
        Container container = this.getParent();
        while (container != null && !(container instanceof Frame)) {
            container = container.getParent();
        }
        if (container == null) {
            return;
        }
        Point point = this.getLocationOnScreen();
        Rectangle rectangle = gTreeEntry.getLabelBounds();
        rectangle.x += point.x;
        rectangle.y += point.y;
        rectangle.width += 12;
        rectangle.height += 5;
        TextEditWindow textEditWindow = new TextEditWindow(this, (Frame)container, gTreeEntry, gTreeEntry.getTreeLabel(), rectangle);
    }

    public void textEditWindowFinished(Object object, String string) {
        ((GTreeEntry)object).setTreeLabel(string);
        this.visibleEntriesModified = true;
        this.tree.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
        int n = mouseEvent.getY() / 16;
        int n2 = mouseEvent.getX() / 16;
        if (n2 < 0 || n < 0) {
            return;
        }
        Vector vector = this.getVisibleEntries();
        if (n > vector.size() - 1) {
            System.err.println("Unter den Baum gedrueckt!");
            return;
        }
        GTreeEntry gTreeEntry = (GTreeEntry)vector.elementAt(n);
        if (gTreeEntry.contains(mouseEvent.getPoint())) {
            if (!gTreeEntry.isSelected()) {
                this.tree.select(gTreeEntry);
                this.lastPoint = mouseEvent.getPoint();
            }
        } else if (n2 == gTreeEntry.getTreeDepth() - 1) {
            if (!gTreeEntry.isTreeLeave()) {
                this.toggleTreeExpansion(gTreeEntry);
            } else {
                System.err.println("Links daneben, aber keine Box zum Expandieren an dieser Stelle.");
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 1) {
            if (!this.tree.isLabelsEditable()) {
                return;
            }
            if (this.lastPoint == null || GfxTools.distance2(this.lastPoint, mouseEvent.getPoint()) < 8.0) {
                System.err.println("Kein Editieren wegen Klick-Punkt zu nahe dran am vorhergehenden");
                return;
            }
            int n = mouseEvent.getY() / 16;
            int n2 = mouseEvent.getX() / 16;
            if (n2 < 0 || n < 0) {
                return;
            }
            Vector vector = this.getVisibleEntries();
            if (n > vector.size() - 1) {
                return;
            }
            GTreeEntry gTreeEntry = (GTreeEntry)vector.elementAt(n);
            if (!gTreeEntry.contains(mouseEvent.getPoint())) {
                System.err.println("Kein Editieren wegen Klick-Punkt nicht innerhalb Eintrag!");
                return;
            }
            if (gTreeEntry.isSelected()) {
                this.edit(gTreeEntry);
            }
        } else if (mouseEvent.getClickCount() == 2) {
            int n = mouseEvent.getY() / 16;
            int n3 = mouseEvent.getX() / 16;
            if (n3 < 0 || n < 0) {
                return;
            }
            Vector vector = this.getVisibleEntries();
            if (n > vector.size() - 1) {
                return;
            }
            GTreeEntry gTreeEntry = (GTreeEntry)vector.elementAt(n);
            int n4 = gTreeEntry.getTreeDepth();
            if (gTreeEntry.contains(mouseEvent.getPoint())) {
                if (!gTreeEntry.isTreeLeave()) {
                    this.toggleTreeExpansion(gTreeEntry);
                } else {
                    this.tree.processActionEvent(new ActionEvent(this.tree, 1001, gTreeEntry.getTreeLabel(), mouseEvent.getModifiers()));
                }
            }
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n != 10 && n != 36 && n != 35 && n != 33 && n != 34 && n != 40 && n != 38 && n != 37 && n != 39) {
            return;
        }
        GTreeEntry gTreeEntry = this.tree.getSelectedEntry();
        if (gTreeEntry == null) {
            this.tree.select(this.tree.getRoot());
            return;
        }
        if (n == 10) {
            if (!gTreeEntry.isTreeLeave()) {
                this.toggleTreeExpansion(gTreeEntry);
            } else {
                this.tree.processActionEvent(new ActionEvent(this.tree, 1001, gTreeEntry.getTreeLabel(), keyEvent.getModifiers()));
            }
            return;
        }
        if (n == 39) {
            if (!gTreeEntry.isTreeExpanded() && !gTreeEntry.isTreeLeave()) {
                this.toggleTreeExpansion(gTreeEntry);
                return;
            }
            if (gTreeEntry.isTreeExpanded()) {
                Vector vector = this.getVisibleEntries();
                int n2 = vector.indexOf(gTreeEntry) + 1;
                if (n2 >= vector.size()) {
                    GTreeCanvas.beep();
                } else {
                    this.tree.select((GTreeEntry)vector.elementAt(n2));
                }
            }
            return;
        }
        if (n == 37) {
            if (gTreeEntry.isTreeExpanded() && !gTreeEntry.isTreeLeave()) {
                this.toggleTreeExpansion(gTreeEntry);
                return;
            }
            GTreeEntry gTreeEntry2 = gTreeEntry.getParent();
            if (gTreeEntry2 == null) {
                GTreeCanvas.beep();
            } else {
                this.tree.select(gTreeEntry2);
            }
            return;
        }
        if (n == 38) {
            Vector vector = this.getVisibleEntries();
            int n3 = vector.indexOf(gTreeEntry) - 1;
            if (n3 < 0) {
                GTreeCanvas.beep();
            } else {
                this.tree.select((GTreeEntry)vector.elementAt(n3));
            }
            return;
        }
        if (n == 40) {
            Vector vector = this.getVisibleEntries();
            int n4 = vector.indexOf(gTreeEntry) + 1;
            if (n4 >= vector.size()) {
                GTreeCanvas.beep();
            } else {
                this.tree.select((GTreeEntry)vector.elementAt(n4));
            }
            return;
        }
        if (n == 35) {
            Vector vector = this.getVisibleEntries();
            int n5 = vector.indexOf(gTreeEntry);
            if (n5 == vector.size() - 1) {
                GTreeCanvas.beep();
            } else {
                this.tree.select((GTreeEntry)vector.elementAt(vector.size() - 1));
            }
            return;
        }
        if (n == 36) {
            Vector vector = this.getVisibleEntries();
            int n6 = vector.indexOf(gTreeEntry);
            if (n6 == 0) {
                GTreeCanvas.beep();
            } else {
                this.tree.select((GTreeEntry)vector.elementAt(0));
            }
            return;
        }
        if (n == 33) {
            Vector vector = this.getVisibleEntries();
            int n7 = vector.indexOf(gTreeEntry);
            if (n7 == 0) {
                GTreeCanvas.beep();
                return;
            }
            Dimension dimension = this.tree.getViewportSize();
            int n8 = dimension.height / 16 - 1;
            if ((n7 -= n8) < 0) {
                n7 = 0;
            }
            this.tree.select((GTreeEntry)vector.elementAt(n7));
            return;
        }
        if (n == 34) {
            Vector vector = this.getVisibleEntries();
            int n9 = vector.indexOf(gTreeEntry);
            if (n9 == vector.size() - 1) {
                GTreeCanvas.beep();
                return;
            }
            Dimension dimension = this.tree.getViewportSize();
            int n10 = dimension.height / 16 - 1;
            if ((n9 += n10) >= vector.size()) {
                n9 = vector.size() - 1;
            }
            this.tree.select((GTreeEntry)vector.elementAt(n9));
            return;
        }
    }

    protected void toggleTreeExpansion(GTreeEntry gTreeEntry) {
        Vector vector;
        gTreeEntry.toggleTreeExpansion();
        this.visibleEntriesModified = true;
        this.tree.repaint();
        if (gTreeEntry.isTreeExpanded() && (vector = gTreeEntry.getChildren()) != null && vector.size() > 0) {
            this.tree.ensureVisible((GTreeEntry)vector.elementAt(vector.size() - 1));
            this.tree.ensureVisible(gTreeEntry);
        }
    }
}

