/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui;

import de.jave.gui.CenterLayout;
import de.jave.gui.GImageCanvas;
import de.jave.gui.GImageLibrary;
import de.jave.gui.GLabel;
import de.jave.gui.GTextButton;
import de.jave.gui.Gap;
import de.jave.gui.GuiTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class GDialog
extends Dialog
implements ActionListener,
KeyListener,
WindowListener {
    protected static final Font FONT_HEADLINE = new Font("Dialog", 1, 13);
    protected GTextButton[] buttons;
    protected int buttonClicked = -1;
    public static final String[] OK = new String[]{"Ok"};
    public static final String[] OK_CANCEL = new String[]{"Ok", "Cancel"};
    public static final String[] CLOSE = new String[]{"Close"};
    public static final String[] YES_NO_CANCEL = new String[]{"Yes", "No", "Cancel"};
    protected char[] shortcuts;
    protected static final String[] STANDARD_BUTTON = OK;
    public static final int TYPE_NONE = -1;
    public static final int ERROR = 0;
    public static final int QUESTION = 1;
    public static final int WARNING = 2;
    public static final int INFO = 3;
    public static final int DELETE = 4;
    public static final int BOMB = 5;
    protected static final String[] STR_IMAGES = new String[]{"dialog_error", "dialog_question", "dialog_warning", "dialog_info", "dialog_dustbin", "dialog_bomb"};

    protected GDialog(Frame frame, String string) {
        super(frame, string, true);
    }

    public GDialog(Frame frame, String string, Component component) {
        this(frame, string, "", component, STANDARD_BUTTON);
    }

    public GDialog(Frame frame, String string, Component component, String[] stringArray) {
        this(frame, string, "", component, stringArray, -1);
    }

    public GDialog(Frame frame, String string, Component component, int n) {
        this(frame, string, component, STANDARD_BUTTON, n);
    }

    public GDialog(Frame frame, String string, Component component, String[] stringArray, int n) {
        this(frame, string, "", component, stringArray, n);
    }

    public GDialog(Frame frame, String string, String string2, Component component) {
        this(frame, string, string2, component, STANDARD_BUTTON);
    }

    public GDialog(Frame frame, String string, String string2, Component component, String[] stringArray) {
        this(frame, string, string2, component, stringArray, -1);
    }

    public GDialog(Frame frame, String string, String string2, Component component, int n) {
        this(frame, string, string2, component, STANDARD_BUTTON, n);
    }

    public GDialog(Frame frame, String string, String string2, Component component, String[] stringArray, int n) {
        super(frame, string, true);
        this.init(string2, component, stringArray, n);
    }

    public GDialog(Frame frame, String string, String string2) {
        this(frame, string, string2, STANDARD_BUTTON);
    }

    public GDialog(Frame frame, String string, String string2, String[] stringArray) {
        this(frame, string, "", string2, stringArray, -1);
    }

    public GDialog(Frame frame, String string, String string2, int n) {
        this(frame, string, string2, STANDARD_BUTTON, n);
    }

    public GDialog(Frame frame, String string, String string2, String[] stringArray, int n) {
        this(frame, string, "", string2, stringArray, n);
    }

    public GDialog(Frame frame, String string, String string2, String string3) {
        this(frame, string, string2, string3, STANDARD_BUTTON);
    }

    public GDialog(Frame frame, String string, String string2, String string3, String[] stringArray) {
        this(frame, string, string2, string3, stringArray, -1);
    }

    public GDialog(Frame frame, String string, String string2, String string3, int n) {
        this(frame, string, string2, string3, STANDARD_BUTTON, n);
    }

    public GDialog(Frame frame, String string, String string2, String string3, String[] stringArray, int n) {
        super(frame, string, true);
        Panel panel = new Panel();
        panel.setLayout(new CenterLayout());
        panel.add(new GLabel(string3, 0));
        this.init(string2, panel, stringArray, n);
    }

    protected void init(String string, Component component, String[] stringArray, int n) {
        int n2;
        Object object;
        this.addWindowListener(this);
        this.addKeyListener(this);
        this.setLayout(new BorderLayout());
        if (n != -1) {
            object = GImageLibrary.getImage(STR_IMAGES[n]);
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage((Image)object, 0);
            try {
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Panel panel = new Panel();
            panel.setLayout(new CenterLayout());
            panel.add(new GImageCanvas((Image)object, 12, 12, 12, 12));
            this.add((Component)panel, "West");
        }
        if (string != null && !string.equals("")) {
            object = new Label(string, 1);
            ((Component)object).setFont(FONT_HEADLINE);
            this.add((Component)object, "North");
        }
        this.add(component, "Center");
        object = new Panel();
        ((Container)object).setLayout(new FlowLayout(1));
        ((Container)object).add(new Gap());
        int n3 = stringArray.length;
        this.shortcuts = new char[n3];
        int n4 = 0;
        while (n4 < n3) {
            this.shortcuts[n4] = '\u0000';
            ++n4;
        }
        int n5 = n3;
        if (stringArray[stringArray.length - 1].equals("Cancel") || stringArray[stringArray.length - 1].equals("Abbrechen")) {
            --n5;
        }
        if (n5 > 1) {
            n2 = 0;
            while (n2 < n5) {
                int n6 = 0;
                boolean bl = false;
                while (n6 < stringArray[n2].length() && !bl) {
                    bl = true;
                    if (stringArray[n2].charAt(n6) == ' ') {
                        bl = false;
                    }
                    int n7 = 0;
                    while (n7 < n2) {
                        if (this.shortcuts[n7] == Character.toLowerCase(stringArray[n2].charAt(n6))) {
                            bl = false;
                            break;
                        }
                        ++n7;
                    }
                    if (bl) continue;
                    ++n6;
                }
                if (n6 < stringArray[n2].length()) {
                    this.shortcuts[n2] = Character.toLowerCase(stringArray[n2].charAt(n6));
                }
                ++n2;
            }
        }
        this.buttons = new GTextButton[stringArray.length];
        n2 = 0;
        while (n2 < stringArray.length) {
            String string2 = stringArray[n2];
            while (string2.length() < 10) {
                string2 = " " + string2 + " ";
            }
            this.buttons[n2] = new GTextButton(string2);
            this.buttons[n2].addActionListener(this);
            this.buttons[n2].addKeyListener(this);
            if (this.shortcuts[n2] != '\u0000') {
                this.buttons[n2].setShortcut(this.shortcuts[n2]);
            }
            ((Container)object).add(this.buttons[n2]);
            ++n2;
        }
        this.add((Component)object, "South");
        this.pack();
        this.setResizable(false);
        GuiTools.centerToFrame(this);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n;
        if (keyEvent.getKeyCode() == 27) {
            this.dispose();
        }
        if (keyEvent.getKeyCode() == 39 || keyEvent.getKeyCode() == 40) {
            Component component = this.getFocusOwner();
            int n2 = 0;
            while (n2 < this.buttons.length) {
                if (this.buttons[n2] == component) {
                    this.buttons[(n2 + 1) % this.buttons.length].requestFocus();
                    return;
                }
                ++n2;
            }
            return;
        }
        if (keyEvent.getKeyCode() == 37 || keyEvent.getKeyCode() == 38) {
            Component component = this.getFocusOwner();
            int n3 = 0;
            while (n3 < this.buttons.length) {
                if (this.buttons[n3] == component) {
                    this.buttons[(n3 - 1 + this.buttons.length) % this.buttons.length].requestFocus();
                    return;
                }
                ++n3;
            }
            return;
        }
        if (keyEvent.getKeyCode() == 10) {
            Object object = keyEvent.getSource();
            n = 0;
            while (n < this.buttons.length) {
                if (this.buttons[n] == object) {
                    this.buttonClicked = n;
                    this.dispose();
                    return;
                }
                ++n;
            }
        }
        char c = keyEvent.getKeyChar();
        n = 0;
        while (n < this.shortcuts.length) {
            if (c != '\u0000' && this.shortcuts[n] == c) {
                this.buttonClicked = n;
                this.dispose();
                return;
            }
            ++n;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        int n = 0;
        while (n < this.buttons.length) {
            if (this.buttons[n] == object) {
                this.buttonClicked = n;
                break;
            }
            ++n;
        }
        this.dispose();
    }

    public int getAnswer() {
        return this.buttonClicked;
    }

    public void windowOpened(WindowEvent windowEvent) {
        this.buttons[0].requestFocus();
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.dispose();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame();
        frame.add(new TextArea(20, 80));
        frame.pack();
        frame.show();
        String[] stringArray2 = new String[]{"Ok", "Cancel"};
        String[][] stringArrayArray = new String[][]{{"Yes", "No", "Cancel"}, {"OK"}, {"Ei Freilich!", "Niemals!", "Cancel"}, {"Alles", "Ach...", "Andernach", "Cancel"}};
        int n = 0;
        while (n < stringArrayArray.length) {
            GDialog gDialog = new GDialog(frame, "Jave", "Save changes to \"test.txt\" ?", stringArrayArray[n], 2);
            gDialog.show();
            int n2 = gDialog.getAnswer();
            if (n2 == -1) {
                System.err.println("BREAK!");
            } else {
                System.err.println(stringArrayArray[n][n2]);
            }
            ++n;
        }
        System.exit(0);
    }
}

