/*
 * Decompiled with CFR 0.152.
 */
package de.jave.figlet;

import de.jave.figlet.FIGCharacter;
import de.jave.figlet.FIGLayout;
import de.jave.text.FastString;

public class FIGFragment
implements Cloneable {
    private FastString[] lines;
    private FIGLayout[] layoutTop;
    private FIGLayout[] layoutBottom;
    private FIGLayout[] layoutLeft;
    private FIGLayout[] layoutRight;
    private int height;
    private int width;
    private int underLength;
    public static final int BOTTOM = 0;
    public static final int TOP = 1;
    public static final int CENTER = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    private int vAlignment = 0;
    private int hAlignment = 4;
    private boolean invertPrintDirection;
    private int maxLineLength;

    private FIGFragment() {
        this.vAlignment = 0;
        this.hAlignment = 4;
    }

    public FIGFragment(FIGCharacter fIGCharacter, FIGLayout fIGLayout, int n, boolean bl, int n2) {
        this.maxLineLength = n2;
        if (fIGCharacter == null) {
            System.err.println("WARNING: FIGCharacter==null in FIGFragment(ch,layout)");
            String[] stringArray = new String[]{" "};
            fIGCharacter = new FIGCharacter(stringArray);
        }
        this.underLength = n;
        this.invertPrintDirection = bl;
        this.height = fIGCharacter.getHeight();
        this.lines = new FastString[this.height];
        int n3 = 0;
        while (n3 < this.height) {
            this.lines[n3] = new FastString(fIGCharacter.getLine(n3));
            ++n3;
        }
        this.width = this.lines[0].length();
        this.layoutLeft = new FIGLayout[this.height];
        this.layoutRight = new FIGLayout[this.height];
        int n4 = 0;
        while (n4 < this.height) {
            this.layoutLeft[n4] = fIGLayout;
            this.layoutRight[n4] = fIGLayout;
            ++n4;
        }
        this.layoutTop = new FIGLayout[this.width];
        this.layoutBottom = new FIGLayout[this.width];
        int n5 = 0;
        while (n5 < this.width) {
            this.layoutTop[n5] = fIGLayout;
            this.layoutBottom[n5] = fIGLayout;
            ++n5;
        }
        this.vAlignment = 0;
        this.hAlignment = 4;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void ensureUnsmushability() {
        if (this.lines[0].charAt(0) == ' ') {
            this.lines[0].setChar(0, '\u007f');
        }
    }

    public void setVAlignment(int n) {
        this.vAlignment = n;
    }

    public void setHAlignment(int n) {
        this.hAlignment = n;
    }

    public int getVAlignment() {
        return this.vAlignment;
    }

    public int getHAlignment() {
        return this.hAlignment;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean isPrintDirectionInverted() {
        return this.invertPrintDirection;
    }

    private void ensureUnderLength(int n) {
        if (this.underLength >= n) {
            return;
        }
        int n2 = n - this.underLength;
        FastString fastString = new FastString(this.width * 2);
        int n3 = 0;
        while (n3 < this.width) {
            fastString.append(' ');
            ++n3;
        }
        FastString[] fastStringArray = new FastString[this.height + n2];
        FIGLayout[] fIGLayoutArray = new FIGLayout[this.height + n2];
        FIGLayout[] fIGLayoutArray2 = new FIGLayout[this.height + n2];
        System.arraycopy(this.lines, 0, fastStringArray, 0, this.height);
        System.arraycopy(this.layoutLeft, 0, fIGLayoutArray, 0, this.height);
        System.arraycopy(this.layoutRight, 0, fIGLayoutArray2, 0, this.height);
        int n4 = this.height;
        while (n4 < this.height + n2) {
            fastStringArray[n4] = fastString;
            fIGLayoutArray[n4] = fIGLayoutArray[this.height - 1];
            fIGLayoutArray2[n4] = fIGLayoutArray2[this.height - 1];
            ++n4;
        }
        this.lines = fastStringArray;
        this.layoutLeft = fIGLayoutArray;
        this.layoutRight = fIGLayoutArray2;
        this.underLength = n;
        this.height += n2;
    }

    private void ensureHeight(int n) {
        if (n <= this.height) {
            return;
        }
        int n2 = 0;
        int n3 = n - 1;
        if (this.vAlignment == 0) {
            n2 = n3 - this.height + 1;
        } else if (this.vAlignment == 1) {
            n3 = this.height - 1;
        } else {
            n2 = (n - this.height) / 2;
            n3 = n2 + this.height - 1;
        }
        FastString fastString = new FastString(this.width * 2);
        int n4 = 0;
        while (n4 < this.width) {
            fastString.append(' ');
            ++n4;
        }
        FastString[] fastStringArray = new FastString[n];
        FIGLayout[] fIGLayoutArray = new FIGLayout[n];
        FIGLayout[] fIGLayoutArray2 = new FIGLayout[n];
        System.arraycopy(this.lines, 0, fastStringArray, n2, n3 - n2 + 1);
        System.arraycopy(this.layoutLeft, 0, fIGLayoutArray, n2, n3 - n2 + 1);
        System.arraycopy(this.layoutRight, 0, fIGLayoutArray2, n2, n3 - n2 + 1);
        int n5 = 0;
        while (n5 < n2) {
            fastStringArray[n5] = fastString;
            fIGLayoutArray[n5] = fIGLayoutArray[n2];
            fIGLayoutArray2[n5] = fIGLayoutArray2[n2];
            ++n5;
        }
        int n6 = n3 + 1;
        while (n6 < n) {
            fastStringArray[n6] = fastString;
            fIGLayoutArray[n6] = fIGLayoutArray[n3];
            fIGLayoutArray2[n6] = fIGLayoutArray2[n3];
            ++n6;
        }
        this.lines = fastStringArray;
        this.layoutLeft = fIGLayoutArray;
        this.layoutRight = fIGLayoutArray2;
        this.height = n;
    }

    private void ensureWidth(int n) {
        int n2;
        int n3;
        if (n <= this.width) {
            return;
        }
        if (this.hAlignment == 4) {
            n3 = 0;
            n2 = n - this.width;
        } else if (this.hAlignment == 8) {
            n3 = n - this.width;
            n2 = 0;
        } else {
            n3 = (n - this.width) / 2;
            n2 = n - n3 - this.width;
        }
        FastString fastString = new FastString(n3);
        int n4 = 0;
        while (n4 < n3) {
            fastString.append(' ');
            ++n4;
        }
        FastString fastString2 = new FastString(n2);
        int n5 = 0;
        while (n5 < n2) {
            fastString2.append(' ');
            ++n5;
        }
        int n6 = 0;
        while (n6 < this.height) {
            this.lines[n6].appendFront(fastString);
            this.lines[n6].append(fastString2);
            ++n6;
        }
        FIGLayout[] fIGLayoutArray = new FIGLayout[n];
        FIGLayout[] fIGLayoutArray2 = new FIGLayout[n];
        int n7 = 0;
        while (n7 < n) {
            if (n7 < n3) {
                fIGLayoutArray[n7] = this.layoutTop[0];
                fIGLayoutArray2[n7] = this.layoutBottom[0];
            } else if (n7 >= n3 + this.width) {
                fIGLayoutArray[n7] = this.layoutTop[this.width - 1];
                fIGLayoutArray2[n7] = this.layoutBottom[this.width - 1];
            } else {
                fIGLayoutArray[n7] = this.layoutTop[n7 - n3];
                fIGLayoutArray2[n7] = this.layoutBottom[n7 - n3];
            }
            ++n7;
        }
        this.layoutTop = fIGLayoutArray;
        this.layoutBottom = fIGLayoutArray2;
        this.width = n;
    }

    public FIGFragment addVertical(FIGFragment fIGFragment) {
        int n;
        if (fIGFragment == null) {
            return this;
        }
        if (this.height == 0 || this.width == 0) {
            return fIGFragment;
        }
        if (fIGFragment.height == 0 || fIGFragment.width == 0) {
            return this;
        }
        int n2 = fIGFragment.getWidth();
        if (n2 < this.getWidth()) {
            n2 = this.getWidth();
        }
        if ((fIGFragment.hAlignment == 8 || fIGFragment.hAlignment == 2) && n2 < fIGFragment.maxLineLength) {
            n2 = fIGFragment.maxLineLength;
        }
        this.ensureWidth(n2);
        fIGFragment.ensureWidth(n2);
        int n3 = this.getWidth();
        FIGLayout[] fIGLayoutArray = new FIGLayout[n3];
        int n4 = 0;
        while (n4 < n3) {
            fIGLayoutArray[n4] = this.layoutBottom[n4].intersect(fIGFragment.layoutTop[n4]);
            ++n4;
        }
        int n5 = 5;
        if (n5 > this.height) {
            n5 = this.height;
        }
        if (n5 > fIGFragment.height) {
            n5 = fIGFragment.height;
        }
        FastString[] fastStringArray = new FastString[this.width];
        int n6 = 0;
        while (n6 < n3) {
            fastStringArray[n6] = new FastString(n5 * 2);
            int n7 = 0;
            while (n7 < n5) {
                fastStringArray[n6].append(this.lines[this.height - n5 + n7].charAt(n6));
                ++n7;
            }
            ++n6;
        }
        FastString[] fastStringArray2 = new FastString[fIGFragment.width];
        int n8 = 0;
        while (n8 < fIGFragment.width) {
            fastStringArray2[n8] = new FastString(n5 * 2);
            n = 0;
            while (n < n5) {
                fastStringArray2[n8].append(fIGFragment.lines[n].charAt(n8));
                ++n;
            }
            ++n8;
        }
        n = 9999;
        int n9 = 0;
        while (n9 < fastStringArray2.length) {
            int n10 = fIGLayoutArray[n9].checkVSmushingDepth(fastStringArray[n9], fastStringArray2[n9]);
            if (n10 < n) {
                n = n10;
            }
            if (n == 0) break;
            ++n9;
        }
        FastString[] fastStringArray3 = new FastString[fastStringArray2.length];
        int n11 = 0;
        while (n11 < fastStringArray2.length) {
            fastStringArray3[n11] = fIGLayoutArray[n11].vSmush(fastStringArray[n11], fastStringArray2[n11], n);
            ++n11;
        }
        FastString[] fastStringArray4 = new FastString[this.height + fIGFragment.height - n];
        System.arraycopy(this.lines, 0, fastStringArray4, 0, this.height - n5);
        int n12 = 0;
        while (n12 < n5 + n5 - n) {
            fastStringArray4[n12 + this.height - n5] = new FastString();
            int n13 = 0;
            while (n13 < fastStringArray3.length) {
                fastStringArray4[n12 + this.height - n5].append(fastStringArray3[n13].charAt(n12));
                ++n13;
            }
            ++n12;
        }
        System.arraycopy(fIGFragment.lines, n5, fastStringArray4, fastStringArray4.length - fIGFragment.height + n5, fIGFragment.height - n5);
        FIGFragment fIGFragment2 = new FIGFragment();
        fIGFragment2.lines = fastStringArray4;
        fIGFragment2.layoutTop = this.layoutTop;
        fIGFragment2.layoutBottom = fIGFragment.layoutBottom;
        fIGFragment2.height = fastStringArray4.length;
        fIGFragment2.width = fastStringArray4[0].length();
        fIGFragment2.layoutLeft = new FIGLayout[fIGFragment2.height];
        fIGFragment2.layoutRight = new FIGLayout[fIGFragment2.height];
        fIGFragment2.underLength = this.underLength;
        fIGFragment2.invertPrintDirection = fIGFragment.invertPrintDirection;
        fIGFragment2.maxLineLength = fIGFragment.maxLineLength;
        int n14 = this.height - n / 2;
        if (n14 < 0) {
            n14 = 0;
        }
        int n15 = fIGFragment2.height - n14;
        System.arraycopy(this.layoutLeft, 0, fIGFragment2.layoutLeft, 0, n14);
        System.arraycopy(this.layoutRight, 0, fIGFragment2.layoutRight, 0, n14);
        System.arraycopy(fIGFragment.layoutLeft, fIGFragment.height - n15, fIGFragment2.layoutLeft, n14, n15);
        System.arraycopy(fIGFragment.layoutRight, fIGFragment.height - n15, fIGFragment2.layoutRight, n14, n15);
        return fIGFragment2;
    }

    public FIGFragment addHorizontal(FIGFragment fIGFragment) {
        if (fIGFragment == null) {
            return this;
        }
        FIGFragment fIGFragment2 = (FIGFragment)this.clone();
        FIGFragment fIGFragment3 = (FIGFragment)fIGFragment.clone();
        if (fIGFragment2.height == 0 || fIGFragment2.width == 0) {
            return fIGFragment3;
        }
        if (fIGFragment3.height == 0 || fIGFragment3.width == 0) {
            return fIGFragment2;
        }
        if (fIGFragment2.isPrintDirectionInverted() && fIGFragment3.isPrintDirectionInverted()) {
            FIGFragment fIGFragment4 = fIGFragment2;
            fIGFragment2 = fIGFragment3;
            fIGFragment3 = fIGFragment4;
        }
        if (fIGFragment2.width == 1 && fIGFragment2.lines[0].charAt(0) == ' ') {
            fIGFragment2.lines[0] = new FastString('\u007f');
        }
        if (fIGFragment3.width == 1 && fIGFragment3.lines[0].charAt(0) == ' ') {
            fIGFragment3.lines[0] = new FastString('\u007f');
        }
        if (fIGFragment3.vAlignment == 0) {
            fIGFragment2.ensureUnderLength(fIGFragment3.underLength);
            fIGFragment3.ensureUnderLength(fIGFragment2.underLength);
        }
        fIGFragment2.ensureHeight(fIGFragment3.getHeight());
        fIGFragment3.ensureHeight(fIGFragment2.getHeight());
        int n = fIGFragment2.getHeight();
        FIGLayout[] fIGLayoutArray = new FIGLayout[n];
        int n2 = 0;
        while (n2 < n) {
            fIGLayoutArray[n2] = fIGFragment2.layoutRight[n2].intersect(fIGFragment3.layoutLeft[n2]);
            ++n2;
        }
        int n3 = 9999;
        int n4 = 0;
        while (n4 < n) {
            int n5 = fIGLayoutArray[n4].checkHSmushingDepth(fIGFragment2.lines[n4], fIGFragment3.lines[n4]);
            if (n5 < n3) {
                n3 = n5;
            }
            if (n3 == 0) break;
            ++n4;
        }
        FastString[] fastStringArray = new FastString[n];
        int n6 = 0;
        while (n6 < n) {
            fastStringArray[n6] = fIGLayoutArray[n6].hSmush(fIGFragment2.lines[n6], fIGFragment3.lines[n6], n3);
            ++n6;
        }
        FIGFragment fIGFragment5 = new FIGFragment();
        fIGFragment5.lines = fastStringArray;
        fIGFragment5.layoutLeft = fIGFragment2.layoutLeft;
        fIGFragment5.layoutRight = fIGFragment3.layoutRight;
        fIGFragment5.height = fastStringArray.length;
        fIGFragment5.width = fastStringArray[0].length();
        fIGFragment5.layoutTop = new FIGLayout[fIGFragment5.width];
        fIGFragment5.layoutBottom = new FIGLayout[fIGFragment5.width];
        fIGFragment5.underLength = fIGFragment3.underLength;
        fIGFragment5.invertPrintDirection = fIGFragment3.invertPrintDirection;
        fIGFragment5.maxLineLength = fIGFragment3.maxLineLength;
        boolean bl = false;
        int n7 = fIGFragment2.width - 1 - n3 / 2;
        if (n7 < 0) {
            n7 = 0;
        }
        int n8 = fIGFragment3.width - 1;
        int n9 = 0;
        while (n9 < fIGFragment5.width) {
            if (n9 <= n7) {
                fIGFragment5.layoutTop[n9] = fIGFragment2.layoutTop[n9];
                fIGFragment5.layoutBottom[n9] = fIGFragment2.layoutBottom[n9];
            } else {
                fIGFragment5.layoutTop[n9] = fIGFragment3.layoutTop[n9 - n7 - 1];
                fIGFragment5.layoutBottom[n9] = fIGFragment3.layoutBottom[n9 - n7 - 1];
            }
            ++n9;
        }
        return fIGFragment5;
    }

    public FastString[] getLines() {
        return this.lines;
    }

    public String getAs(int n) {
        switch (n) {
            case -1: {
                return this.getAsRAW();
            }
            case 0: {
                return this.getAsASCII();
            }
            case 1: {
                return this.getAsHTML();
            }
            case 2: {
                return this.getAsTEX();
            }
            case 5: {
                return this.getAsJAVA();
            }
            case 3: {
                return this.getAsCPP();
            }
            case 4: {
                return this.getAsC();
            }
            case 7: {
                return this.getAsModula2();
            }
            case 6: {
                return this.getAsModula2B();
            }
            case 8: {
                return this.getAsShell1();
            }
            case 9: {
                return this.getAsShell2();
            }
            case 10: {
                return this.getAsShell3();
            }
        }
        return this.getAsASCII();
    }

    private String getAsASCII() {
        FastString fastString = new FastString(this.lines.length * (this.maxLineLength + 1));
        int n = 0;
        while (n < this.lines.length) {
            this.lines[n].replace('\u007f', ' ');
            this.lines[n].trimRight();
            fastString.append(this.lines[n]);
            fastString.append('\n');
            ++n;
        }
        return fastString.toString();
    }

    private String getAsRAW() {
        FastString fastString = new FastString(this.lines.length * (this.maxLineLength + 1));
        int n = 0;
        while (n < this.lines.length) {
            this.lines[n].replace('\u007f', ' ');
            fastString.append(this.lines[n]);
            fastString.append('\n');
            ++n;
        }
        return fastString.toString();
    }

    private String getAsTEX() {
        String string = "% Vielen Dank f\"ur die Bereitstellung dieses TeX-Headers an\n% Torsten Ullrich\n% \\documentstyle[german, a4]{article}\n\\documentclass{article}\n\\usepackage{a4, german}\n\n\\begin{document}\n\n%\"Andern der Schriftgr\"o\"se\n\n% \\tiny\n\\scriptsize\n% \\footnotesize\n% \\small\n% \\normalsize\n% \\large\n% \\Large\n% \\LARGE\n% \\huge\n% \\Huge\n\n%In der folgenden Umgebung\n%wird der ASCII-Text genau so dargestellt, wie er in der \n%Umgebung steht. Einzige Ausnahme: Der Befehl zum Beenden der Umgebung\n%kann in einer solchen Umgebung nicht ausgegeben werden. Dies stellt\n%jedoch keine ernsthafte Einschr\"ankung\n\n\n\\begin{verbatim}\n";
        String string2 = "\\end{verbatim}\n\\end{document}";
        return this.getBlockCommented(string, string2);
    }

    private String getAsHTML() {
        FastString fastString = new FastString(this.lines.length * (this.maxLineLength + 1) + 500);
        fastString.append("<!-- this code fragment was automatically generate using FigletFIGML 0.1 -->\n");
        fastString.append("<table border=0>\n");
        fastString.append("<tr><td>\n");
        fastString.append("<code><pre>\n");
        int n = 0;
        while (n < this.lines.length) {
            this.lines[n].replace('\u007f', ' ');
            this.lines[n].trimRight();
            String string = this.lines[n].toString();
            int n2 = string.indexOf(60);
            while (n2 != -1) {
                string = string.substring(0, n2) + "&lt;" + string.substring(n2 + 1);
                n2 = string.indexOf(60, n2 - 1);
            }
            n2 = string.indexOf(62);
            while (n2 != -1) {
                string = string.substring(0, n2) + "&gt;" + string.substring(n2 + 1);
                n2 = string.indexOf(62, n2 - 1);
            }
            fastString.append(string);
            fastString.append('\n');
            ++n;
        }
        fastString.append("</pre></code>\n");
        fastString.append("</td></tr>\n");
        fastString.append("</table>\n");
        fastString.append("<!-- end of figlet code -->");
        return fastString.toString();
    }

    private String getAsJAVA() {
        FastString fastString = new FastString(this.lines.length * (this.maxLineLength + 4) + 6);
        fastString.append("/**\n");
        int n = 0;
        while (n < this.lines.length) {
            this.lines[n].replace('\u007f', ' ');
            fastString.append("* ");
            fastString.append(this.lines[n]);
            fastString.append('\n');
            ++n;
        }
        fastString.append("*/");
        return fastString.toString();
    }

    private String getAsCPP() {
        return this.getLineCommented("// ", "");
    }

    private String getAsC() {
        return this.getBlockCommented("/*", "*/");
    }

    private String getAsModula2() {
        return this.getBlockCommented("(*", "*)");
    }

    private String getAsModula2B() {
        return this.getLineCommented("(* ", "*)");
    }

    private String getAsShell1() {
        return this.getLineCommented("# ", "");
    }

    private String getAsShell2() {
        return this.getLineCommented("; ", "");
    }

    private String getAsShell3() {
        return this.getLineCommented("% ", "");
    }

    private String getLineCommented(String string, String string2) {
        FastString fastString = new FastString(this.lines.length * (this.maxLineLength + 1 + string2.length() + string.length()));
        int n = 0;
        while (n < this.lines.length) {
            this.lines[n].replace('\u007f', ' ');
            fastString.append(string);
            fastString.append(this.lines[n]);
            fastString.append(string2);
            fastString.append('\n');
            ++n;
        }
        return fastString.toString();
    }

    private String getBlockCommented(String string, String string2) {
        FastString fastString = new FastString(this.lines.length * (this.maxLineLength + 1) + string.length() + string2.length());
        fastString.append(string);
        fastString.append('\n');
        int n = 0;
        while (n < this.lines.length) {
            this.lines[n].replace('\u007f', ' ');
            this.lines[n].trimRight();
            fastString.append(this.lines[n]);
            fastString.append('\n');
            ++n;
        }
        fastString.append(string2);
        return fastString.toString();
    }

    public void print() {
        System.out.println("Width: " + this.width + " Height: " + this.height + " UnderLength:" + this.underLength);
        System.out.print("_|");
        int n = 0;
        while (n < this.width) {
            if (this.layoutTop[n] != null) {
                System.out.print("_");
            } else {
                System.out.print("*");
            }
            ++n;
        }
        System.out.println("|_");
        int n2 = 0;
        while (n2 < this.height) {
            if (this.layoutLeft[n2] != null) {
                System.out.print("_");
            } else {
                System.out.print("*");
            }
            System.out.print("|");
            System.out.print(this.lines[n2]);
            System.out.print("|");
            if (this.layoutRight[n2] != null) {
                System.out.print("_");
            } else {
                System.out.print("*");
            }
            if (n2 == this.height - this.underLength - 1) {
                System.out.println("__/");
            } else {
                System.out.println();
            }
            ++n2;
        }
        System.out.print(" |");
        int n3 = 0;
        while (n3 < this.width) {
            if (this.layoutBottom[n3] != null) {
                System.out.print("^");
            } else {
                System.out.print("*");
            }
            ++n3;
        }
        System.out.println("| ");
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"abc", "def", "ghi"};
        FIGCharacter fIGCharacter = new FIGCharacter(stringArray2);
        FIGLayout fIGLayout = new FIGLayout(255);
        FIGFragment fIGFragment = new FIGFragment(fIGCharacter, fIGLayout, 2, false, 70);
        fIGFragment.ensureHeight(4);
        fIGFragment.ensureHeight(5);
    }
}

