/*
 * Decompiled with CFR 0.152.
 */
package de.jave.figlet;

import de.jave.figlet.FIGControlFile;
import de.jave.figlet.FIGControlFileList;
import de.jave.figlet.FIGFileManager;
import de.jave.figlet.FIGFont;
import de.jave.figlet.FIGFontCache;
import de.jave.figlet.FIGFragment;
import de.jave.figlet.FIGMLToken;
import de.jave.figlet.FIGMLTokenizer;
import de.jave.util.WarningCollector;
import java.io.File;

public class FIGDriver {
    public static final String PROGRAM_NAME = "FigletFIGML 0.1";
    public static final int LINE_LENGTH_DEFAULT = 80;
    public static final int RAW = -1;
    public static final int ASCII = 0;
    public static final int HTML = 1;
    public static final int TEX = 2;
    public static final int CPP = 3;
    public static final int C = 4;
    public static final int JAVA = 5;
    public static final int MODULA2B = 6;
    public static final int MODULA2 = 7;
    public static final int SHELL1 = 8;
    public static final int SHELL2 = 9;
    public static final int SHELL3 = 10;
    public static final int FORMAT_DEFAULT = 0;
    public static final String[] FORMAT_STR = new String[]{"ascii", "html", "tex", "c++", "c", "java", "modula2b", "modula2", "shell1", "shell2", "shell3"};
    private FIGFontCache cache;
    private FIGFont font;
    private FIGControlFileList controlFiles;
    private int vAlign = 0;
    private int hAlign = 4;
    private static WarningCollector warner;

    public FIGDriver() {
        this(new WarningCollector());
    }

    public FIGDriver(WarningCollector warningCollector) {
        warner = warningCollector;
        this.cache = new FIGFontCache();
    }

    protected void setFont(String string) {
        FIGFont fIGFont = this.cache.get(string);
        this.font = fIGFont != null ? fIGFont : this.cache.get(FIGFileManager.getDefaultFontName());
    }

    public void forceFontReload(String string, File file) {
        FIGFont fIGFont = FIGFont.load(string, file);
        this.font = fIGFont != null ? fIGFont : this.cache.get(FIGFileManager.getDefaultFontName());
    }

    public String getFontComment(String string) {
        FIGFont fIGFont = this.cache.get(string);
        if (fIGFont != null) {
            return fIGFont.getComments();
        }
        return "No such Font: '" + string + ".flf'";
    }

    public String getFontInfo(String string) {
        FIGFont fIGFont = this.cache.get(string);
        if (fIGFont != null) {
            return fIGFont.getInfo();
        }
        return "No such Font: '" + string + ".flf'";
    }

    public String[] getFontInfos(String string) {
        FIGFont fIGFont = this.cache.get(string);
        if (fIGFont != null) {
            return fIGFont.getInfos();
        }
        return null;
    }

    public int getFontHeight(String string) {
        FIGFont fIGFont = this.cache.get(string);
        if (fIGFont != null) {
            return fIGFont.getHeight();
        }
        return 1;
    }

    public int getFontUnderLength(String string) {
        FIGFont fIGFont = this.cache.get(string);
        if (fIGFont != null) {
            return fIGFont.getUnderLength();
        }
        return 0;
    }

    private void addControlFile(String string) {
        FIGControlFile fIGControlFile;
        boolean bl;
        if (this.controlFiles == null) {
            this.controlFiles = new FIGControlFileList();
        }
        if (!(bl = (fIGControlFile = new FIGControlFile(string)).load())) {
            FIGDriver.warning("Unable to load control file " + string + " - ignored.");
            return;
        }
        this.controlFiles.add(fIGControlFile);
    }

    private void removeControlFile(String string) {
        boolean bl = this.controlFiles.remove(string);
        if (!bl) {
            FIGDriver.warning("Trying to close control file " + string + " that has not been loaded - ignored.");
        }
    }

    private void removeAllControlFiles() {
        this.controlFiles = null;
    }

    public void setVAlignment(String string) {
        if ((string = string.toLowerCase()).equals("bottom")) {
            this.vAlign = 0;
        } else if (string.equals("top")) {
            this.vAlign = 1;
        } else if (string.equals("center")) {
            this.vAlign = 2;
        } else {
            System.err.println("Unbekannte Option f\u00fcr vertikales Alignment: " + string);
            this.vAlign = 0;
        }
    }

    public void setHAlignment(String string) {
        if ((string = string.toLowerCase()).equals("left")) {
            this.hAlign = 4;
        } else if (string.equals("right")) {
            this.hAlign = 8;
        } else if (string.equals("center")) {
            this.hAlign = 2;
        } else {
            System.err.println("Unbekannte Option f\u00fcr horizontales Alignment: " + string);
            this.hAlign = 4;
        }
    }

    private FIGFragment figletizeRaw(String string, int n) {
        if (this.font == null) {
            System.err.println("FONT==NULL!!!!!");
        }
        FIGFragment fIGFragment = null;
        int n2 = 0;
        while (n2 < string.length()) {
            int n3;
            int n4 = n3 = string.charAt(n2);
            if (this.controlFiles != null) {
                n4 = this.controlFiles.map((char)n3);
            }
            FIGFragment fIGFragment2 = new FIGFragment(this.font.getFIGCharacter(n4), this.font.layout, this.font.getUnderLength(), this.font.isPrintDirectionInverted(), n);
            FIGFragment fIGFragment3 = null;
            fIGFragment3 = fIGFragment == null ? fIGFragment2 : fIGFragment.addHorizontal(fIGFragment2);
            fIGFragment = fIGFragment != null ? fIGFragment3 : fIGFragment2;
            ++n2;
        }
        fIGFragment.setVAlignment(this.vAlign);
        fIGFragment.setHAlignment(this.hAlign);
        if (fIGFragment.getWidth() > n) {
            FIGDriver.warning("The word \"" + string + "\"exceeds the maximum length of a single line.");
        }
        return fIGFragment;
    }

    private String clearHardblanks(String string) {
        return string.replace('\u007f', ' ');
    }

    public static void warning(String string) {
        if (warner != null) {
            warner.add(string);
        }
    }

    private String FIGMLParse(String string, String string2) {
        int n;
        int n2 = 0;
        int n3 = 0;
        while (n3 < FORMAT_STR.length) {
            n = string2.indexOf(FORMAT_STR[n3]);
            if (n != -1) {
                n2 = n3;
                string2 = string2.substring(n + FORMAT_STR[n3].length()).trim();
                break;
            }
            ++n3;
        }
        int n4 = 80;
        try {
            n4 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            FIGDriver.warning("Illegal option for length of line: '" + string2 + "'");
        }
        n = string.indexOf("\n");
        while (n != -1) {
            string = n == string.length() ? string.substring(0, string.length() - 1) : (n == 0 ? string.substring(1) : (string.charAt(n - 1) == '>' ? string.substring(0, n) + string.substring(n + 1) : string.substring(0, n) + " " + string.substring(n + 1)));
            n = string.indexOf("\n", n);
        }
        string = string.replace('\t', ' ');
        string = string.replace('\f', ' ');
        string = string.replace('\r', ' ');
        n = string.indexOf("  ");
        while (n != -1) {
            string = string.substring(0, n) + string.substring(n + 1);
            n = string.indexOf("  ");
        }
        n = string.indexOf(" <br>");
        while (n != -1) {
            string = string.substring(0, n) + string.substring(n + 1);
            n = string.indexOf(" <br>");
        }
        FIGFragment fIGFragment = null;
        FIGFragment fIGFragment2 = null;
        FIGMLTokenizer fIGMLTokenizer = new FIGMLTokenizer(string);
        FIGMLToken fIGMLToken = fIGMLTokenizer.nextToken();
        while (fIGMLToken != null) {
            FIGFragment fIGFragment3;
            if (fIGMLToken.type == 6) {
                this.setFont(fIGMLToken.text);
            } else if (fIGMLToken.type == 7) {
                this.addControlFile(fIGMLToken.text);
            } else if (fIGMLToken.type == 8) {
                this.removeControlFile(fIGMLToken.text);
            } else if (fIGMLToken.type == 9) {
                this.removeAllControlFiles();
            } else if (fIGMLToken.type == 4) {
                this.setVAlignment(fIGMLToken.text);
            } else if (fIGMLToken.type == 5) {
                this.setHAlignment(fIGMLToken.text);
            } else if (fIGMLToken.type == 1) {
                if (fIGFragment2 == null) {
                    fIGFragment2 = new FIGFragment(this.font.getFIGCharacter(32), this.font.layout, this.font.getUnderLength(), this.font.isPrintDirectionInverted(), n4);
                }
                fIGFragment = fIGFragment == null ? (FIGFragment)fIGFragment2.clone() : fIGFragment.addVertical(fIGFragment2);
                fIGFragment2 = null;
            } else if (fIGMLToken.type == 11) {
                if (fIGFragment2 == null) {
                    fIGFragment2 = new FIGFragment(this.font.getFIGCharacter(32), this.font.layout, this.font.getUnderLength(), this.font.isPrintDirectionInverted(), n4);
                }
                fIGFragment = fIGFragment == null ? (FIGFragment)fIGFragment2.clone() : fIGFragment.addVertical(fIGFragment2);
                fIGFragment3 = this.figletizeRaw(fIGMLToken.text, n4);
                if (fIGFragment3.getWidth() == 1) {
                    fIGFragment3.ensureUnsmushability();
                }
                fIGFragment3.setVAlignment(2);
                fIGFragment3.setHAlignment(2);
                fIGFragment2 = fIGFragment3;
                fIGFragment3 = this.figletizeRaw(fIGMLToken.text, n4);
                if (fIGFragment3.getWidth() == 1) {
                    fIGFragment3.ensureUnsmushability();
                }
                while (fIGFragment3.getWidth() + fIGFragment2.getWidth() < n4) {
                    fIGFragment2 = fIGFragment2.addHorizontal(fIGFragment3);
                }
                fIGFragment = fIGFragment == null ? fIGFragment2 : fIGFragment.addVertical(fIGFragment2);
                fIGFragment2 = null;
            } else if (fIGMLToken.type == 0) {
                fIGFragment3 = this.figletizeRaw(fIGMLToken.text, n4);
                fIGFragment3.setVAlignment(this.vAlign);
                fIGFragment3.setHAlignment(this.hAlign);
                if (fIGFragment2 == null) {
                    fIGFragment2 = fIGFragment3;
                } else {
                    FIGFragment fIGFragment4 = (FIGFragment)fIGFragment2.clone();
                    if ((fIGFragment4 = fIGFragment4.addHorizontal(fIGFragment3)).getWidth() > n4) {
                        fIGFragment = fIGFragment == null ? fIGFragment2 : fIGFragment.addVertical(fIGFragment2);
                        fIGFragment2 = fIGFragment3;
                    } else {
                        fIGFragment2 = fIGFragment4;
                        fIGFragment2.setVAlignment(this.vAlign);
                        fIGFragment2.setHAlignment(this.hAlign);
                    }
                }
            } else {
                System.out.println("Token noch unbekannt - ignoriert");
            }
            fIGMLToken = fIGMLTokenizer.nextToken();
        }
        if (fIGFragment2 == null && fIGFragment == null) {
            fIGFragment = new FIGFragment(this.font.getFIGCharacter(32), this.font.layout, this.font.getUnderLength(), this.font.isPrintDirectionInverted(), n4);
        } else if (fIGFragment == null && fIGFragment2 != null) {
            fIGFragment = fIGFragment2;
        } else if (fIGFragment != null && fIGFragment2 != null) {
            fIGFragment = fIGFragment.addVertical(fIGFragment2);
        }
        return fIGFragment.getAs(n2);
    }

    private void reset() {
        this.removeAllControlFiles();
        this.vAlign = 0;
        this.hAlign = 4;
    }

    public String FIGML(String string) {
        if (string.startsWith("<raw ")) {
            int n = string.indexOf(62);
            if (n < 5) {
                return "";
            }
            String string2 = string.substring(5, n);
            this.reset();
            this.setFont(string2);
            String string3 = string.substring(n + 1);
            if (string3.length() == 0) {
                return "";
            }
            FIGFragment fIGFragment = null;
            int n2 = 0;
            while (n2 < string3.length()) {
                char c;
                char c2 = c = string3.charAt(n2);
                FIGFragment fIGFragment2 = new FIGFragment(this.font.getFIGCharacter(c2), this.font.layout, this.font.getUnderLength(), this.font.isPrintDirectionInverted(), 100);
                fIGFragment = fIGFragment != null ? fIGFragment.addHorizontal(fIGFragment2) : fIGFragment2;
                ++n2;
            }
            return fIGFragment.getAs(-1);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.indexOf("<figlet");
        while (n != -1) {
            int n3;
            stringBuffer.append(string.substring(0, n));
            int n4 = string.indexOf(">", n + 5);
            if (n4 == -1) {
                // empty if block
            }
            String string4 = string.substring(n + 7, n4).trim().toLowerCase();
            int n5 = string.indexOf("</fig");
            if (n5 == -1) {
                n5 = string.length() - 5;
            }
            if ((n3 = string.indexOf(">", n5)) == -1) {
                n3 = n5;
            }
            String string5 = string.substring(n4 + 1, n5);
            this.reset();
            String string6 = this.FIGMLParse(string5, string4);
            stringBuffer.append(string6);
            string = string.substring(n3 + 1);
            n = string.indexOf("<figlet");
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        FIGDriver fIGDriver = new FIGDriver();
        String string = "<figlethtml100><halign=left><italic.flf>Hallo Torsten,<br><standard.flf>Ich will Dir kurz vorf\u00fchren, was mein <larry3d.flf>Figlet<standard.flf> mit FIGML <small.flf>(FIGlet Markup Language)<standard.flf>schon so alles kann.<br><halign=center>Zum Beispiel kann man die Ausrichtung horizontal und<br> <valign=center>v<arrows.flf>er<term.flf>ti<block.flf>ka<standard.flf>l<valign=top> anpassen,<valign=bottom> oder die <smslant.flf>Schriftart<puffy.flf>wechseln.<standard.flf><br><halign=right>Sch\u00f6ne Gr\u00fc\u00dfe, <script.flf>Markus</fig>PS: Der Quelltext dazu sieht so aus:\n< figlethtml100><halign=left><italic.flf>Hallo Torsten,<br><standard.flf>Ich will Dir kurz vorf\u00fchren, was mein <larry3d.flf>Figlet<standard.flf> mit FIGML <small.flf>(FIGlet Markup Language)<standard.flf>schon so alles kann.<br><halign=center>Zum Beispiel kann man die Ausrichtung horizontal und<br> <valign=center>v<arrows.flf>er<term.flf>ti<block.flf>ka<standard.flf>l<valign=top> anpassen,<valign=bottom> oder die <smslant.flf>Schriftart<puffy.flf>wechseln.<standard.flf><br><halign=right>Sch\u00f6ne Gr\u00fc\u00dfe, <script.flf>Markus</fig>";
        String string2 = fIGDriver.FIGML(string);
        System.out.println(string2);
    }
}

