/*
 * Decompiled with CFR 0.152.
 */
package de.jave.braille;

import de.jave.braille.BrailleTable;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.StringTokenizer;

public class BrailleDisplay
extends Canvas
implements KeyListener,
MouseListener {
    protected String[] lines;
    protected int maxLineLength;
    protected static final int[] CHAR_WIDTH = new int[]{10, 11, 12, 14, 17};
    protected static final int[] CHAR_HEIGHT = new int[]{20, 23, 26, 29, 35};
    protected static final int[] DY = new int[]{4, 5, 5, 6, 7};
    protected static final int[] DX = new int[]{3, 3, 4, 6, 6};
    protected static final int[] X0 = new int[]{2, 2, 2, 2, 3};
    protected static final int[] Y0 = new int[]{2, 2, 3, 3, 4};
    protected static final int[] DOT_HEIGHT = new int[]{2, 2, 3, 3, 4};
    protected static final int[] DOT_WIDTH = new int[]{2, 2, 3, 3, 4};
    protected int charWidth = CHAR_WIDTH[0];
    protected int charHeight = CHAR_HEIGHT[0];
    protected int dx = DX[0];
    protected int dy = DY[0];
    protected int x0 = X0[0];
    protected int y0 = Y0[0];
    protected int dotHeight;
    protected int dotWidth = DOT_WIDTH[0];
    protected int viewSize = 0;
    protected int mode = 0;

    public BrailleDisplay() {
        this("");
    }

    public BrailleDisplay(String string) {
        this.dotHeight = DOT_HEIGHT[0];
        this.setText(string);
        this.addKeyListener(this);
        this.addMouseListener(this);
    }

    public void setMode(int n) {
        if (n == this.mode) {
            return;
        }
        this.mode = n;
        this.repaint();
    }

    public void setViewSize(int n) {
        if (n == this.viewSize) {
            return;
        }
        this.viewSize = n;
        this.charWidth = CHAR_WIDTH[this.viewSize];
        this.charHeight = CHAR_HEIGHT[this.viewSize];
        this.dx = DX[this.viewSize];
        this.dy = DY[this.viewSize];
        this.x0 = X0[this.viewSize];
        this.y0 = Y0[this.viewSize];
        this.dotWidth = DOT_WIDTH[this.viewSize];
        this.dotHeight = DOT_HEIGHT[this.viewSize];
        this.invalidate();
        Container container = this.getParent();
        if (container != null) {
            container.doLayout();
        }
        this.repaint();
    }

    public void setText(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        int n = stringTokenizer.countTokens();
        this.lines = new String[n];
        int n2 = 0;
        this.maxLineLength = 0;
        while (stringTokenizer.hasMoreTokens()) {
            this.lines[n2] = stringTokenizer.nextToken();
            if (this.lines[n2].length() > this.maxLineLength) {
                this.maxLineLength = this.lines[n2].length();
            }
            ++n2;
        }
        this.invalidate();
        Container container = this.getParent();
        if (container != null) {
            container.doLayout();
        }
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.maxLineLength * this.charWidth, this.lines.length * this.charHeight);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void update(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        int n;
        graphics.setColor(Color.gray);
        int n2 = 0;
        while (n2 < this.lines.length) {
            n = 0;
            while (n < this.lines[n2].length()) {
                graphics.drawRect(n * this.charWidth, n2 * this.charHeight, this.charWidth - 2, this.charHeight - 3);
                ++n;
            }
            ++n2;
        }
        graphics.setColor(Color.black);
        n = 0;
        while (n < this.lines.length) {
            int n3 = 0;
            while (n3 < this.lines[n].length()) {
                this.paintBraille(graphics, n3 * this.charWidth, n * this.charHeight, this.lines[n].charAt(n3));
                ++n3;
            }
            ++n;
        }
    }

    protected final void paintBraille(Graphics graphics, int n, int n2, char c) {
        int n3 = BrailleTable.getCode(this.mode, c);
        int n4 = n + this.x0;
        int n5 = n4 + this.dx;
        int n6 = n2 + this.y0;
        int n7 = n6 + this.dy;
        int n8 = n7 + this.dy;
        int n9 = n8 + this.dy;
        if ((n3 & 1) > 0) {
            this.paintBrailleDot(graphics, n4, n6);
        }
        if ((n3 & 2) > 0) {
            this.paintBrailleDot(graphics, n4, n7);
        }
        if ((n3 & 4) > 0) {
            this.paintBrailleDot(graphics, n4, n8);
        }
        if ((n3 & 8) > 0) {
            this.paintBrailleDot(graphics, n5, n6);
        }
        if ((n3 & 0x10) > 0) {
            this.paintBrailleDot(graphics, n5, n7);
        }
        if ((n3 & 0x20) > 0) {
            this.paintBrailleDot(graphics, n5, n8);
        }
        if ((n3 & 0x40) > 0) {
            this.paintBrailleDot(graphics, n4, n9);
        }
        if ((n3 & 0x80) > 0) {
            this.paintBrailleDot(graphics, n5, n9);
        }
    }

    protected final void paintBrailleDot(Graphics graphics, int n, int n2) {
        graphics.fillRect(n, n2, this.dotWidth, this.dotHeight);
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c == '+' || c == ')' || c == '9') {
            this.incViewSize();
        } else if (c == '-' || c == '(' || c == '8') {
            this.decViewSize();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isMetaDown()) {
            this.incViewSize();
        } else {
            this.decViewSize();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void incViewSize() {
        if (this.viewSize < CHAR_WIDTH.length - 1) {
            this.setViewSize(this.viewSize + 1);
        }
    }

    public void decViewSize() {
        if (this.viewSize > 0) {
            this.setViewSize(this.viewSize - 1);
        }
    }
}

